/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.tlv;

import de.gematik.smartcards.tlv.BerTlv;
import de.gematik.smartcards.tlv.ClassOfTag;
import de.gematik.smartcards.utils.AfiUtils;
import de.gematik.smartcards.utils.Hex;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.VisibleForTesting;

@SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
public class PrimitiveBerTlv
extends BerTlv {
    @VisibleForTesting
    static final String EMC = "tag-field indicates constructed encoding";
    @VisibleForTesting
    static final String EM_EOS = "unexpected end of stream while reading a value-field";
    @VisibleForTesting
    static final String EM_INDEFINITE = "indefinite form for length-field not allowed";
    @VisibleForTesting
    static final String EM_TOO_LONG = "length too big";
    final byte[] insValueField;

    PrimitiveBerTlv(byte[] tag, ByteBuffer buffer) {
        super(tag, buffer);
        this.checkTag();
        if (this.insIndefiniteForm) {
            throw new IllegalArgumentException(EM_INDEFINITE);
        }
        if (this.insLengthOfValueFieldFromStream > Integer.MAX_VALUE) {
            throw new ArithmeticException(EM_TOO_LONG);
        }
        int length = (int)this.insLengthOfValueFieldFromStream;
        this.insValueField = new byte[length];
        buffer.get(this.insValueField);
        this.insLengthOfValueField = this.insLengthOfValueFieldFromStream;
    }

    PrimitiveBerTlv(byte[] tag, InputStream inputStream) throws IOException {
        super(tag, inputStream);
        this.checkTag();
        if (this.insIndefiniteForm) {
            throw new IllegalArgumentException(EM_INDEFINITE);
        }
        if (this.insLengthOfValueFieldFromStream > Integer.MAX_VALUE) {
            throw new ArithmeticException(EM_TOO_LONG);
        }
        int length = (int)this.insLengthOfValueFieldFromStream;
        this.insValueField = inputStream.readNBytes(length);
        if (length > this.insValueField.length) {
            throw new EOFException(EM_EOS);
        }
        this.insLengthOfValueField = this.insLengthOfValueFieldFromStream;
    }

    PrimitiveBerTlv(long tag, byte[] valueField) {
        super(tag, valueField.length);
        this.checkTag();
        this.insValueField = (byte[])valueField.clone();
        this.insLengthOfValueField = this.insValueField.length;
    }

    private void checkTag() {
        if (0 != (this.insTagLengthField[0] & 0x20)) {
            throw new IllegalArgumentException(EMC);
        }
    }

    public static byte[] createTag(ClassOfTag classOfTag, long number) {
        return PrimitiveBerTlv.createTag(classOfTag, false, number);
    }

    @Override
    public final boolean equals(@CheckForNull Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        PrimitiveBerTlv other = (PrimitiveBerTlv)obj;
        return this.insValueField.length == other.insValueField.length && Arrays.equals(this.insValueField, other.insValueField);
    }

    @Override
    public final byte[] getValueField() {
        return (byte[])this.insValueField.clone();
    }

    @Override
    public final int hashCode() {
        int result = this.insHashCode;
        if (0 == result) {
            result = super.hashCode();
            int hashCodeMultiplier = 31;
            this.insHashCode = result = result * 31 + Arrays.hashCode(this.insValueField);
        }
        return result;
    }

    @Override
    public final byte[] getEncoded() {
        return AfiUtils.concatenate((byte[][])new byte[][]{this.insTagLengthField, this.insValueField});
    }

    @Override
    @VisibleForTesting
    final ByteArrayOutputStream getEncoded(ByteArrayOutputStream out) {
        super.getEncoded(out).writeBytes(this.insValueField);
        return out;
    }

    @Override
    String toString(String delimiter, String delo, int noIndentation, boolean addComment) {
        String comment = addComment ? this.getComment() : "";
        return this.tagLength2String(delimiter, delo, noIndentation).append(0L == this.getLengthOfValueField() ? "" : delimiter).append(Hex.toHexDigits((byte[])this.insValueField)).append(comment).toString();
    }
}

