/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.tlv;

import de.gematik.smartcards.tlv.PrimitiveSpecific;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.VisibleForTesting;

public final class DerUtf8String
extends PrimitiveSpecific<String> {
    public static final int TAG = 12;
    @Nullable
    volatile String insDecoded;

    public DerUtf8String(String value) {
        super(12L, value.getBytes(StandardCharsets.UTF_8));
        this.insDecoded = value;
    }

    DerUtf8String(ByteBuffer buffer) {
        super(new byte[]{12}, buffer);
    }

    DerUtf8String(InputStream inputStream) throws IOException {
        super(new byte[]{12}, inputStream);
    }

    @Override
    public String getComment() {
        return " # UTF8String := \"" + this.getDecoded() + "\"";
    }

    @Override
    public String getDecoded() {
        String result = this.insDecoded;
        if (null == result) {
            if (!DerUtf8String.checkEncoding(this.insValueField)) {
                this.insFindings.add("invalid encoding");
            }
            this.insDecoded = result = new String(this.insValueField, StandardCharsets.UTF_8);
        }
        return result;
    }

    @VisibleForTesting
    static boolean checkEncoding(byte[] octet) {
        try {
            ByteBuffer buffer = ByteBuffer.wrap(octet);
            while (buffer.hasRemaining()) {
                boolean finding;
                byte b1 = buffer.get();
                if (192 == (b1 & 0xE0)) {
                    b2 = buffer.get();
                    finding = DerUtf8String.checkEncoding2(b1, b2);
                } else if (224 == (b1 & 0xF0)) {
                    b2 = buffer.get();
                    b3 = buffer.get();
                    finding = DerUtf8String.checkEncoding3(b1, b2, b3);
                } else if (240 == (b1 & 0xF8)) {
                    b2 = buffer.get();
                    b3 = buffer.get();
                    byte b4 = buffer.get();
                    finding = DerUtf8String.checkEncoding4(b1, b2, b3, b4);
                } else {
                    boolean bl = finding = b1 < 0;
                }
                if (!finding) continue;
                return false;
            }
        }
        catch (BufferUnderflowException e) {
            return false;
        }
        return true;
    }

    private static boolean checkEncoding2(byte b1, byte b2) {
        if (128 != (b2 & 0xC0)) {
            return true;
        }
        int codePoint = (b1 & 0x1F) << 6 | b2 & 0x3F;
        return 128 > codePoint;
    }

    private static boolean checkEncoding3(byte b1, byte b2, byte b3) {
        if (128 != (b2 & 0xC0) || 128 != (b3 & 0xC0)) {
            return true;
        }
        int codePoint = ((b1 & 0xF) << 6 | b2 & 0x3F) << 6 | b3 & 0x3F;
        return 2048 > codePoint || 55296 <= codePoint && codePoint <= 57343;
    }

    private static boolean checkEncoding4(byte b1, byte b2, byte b3, byte b4) {
        if (128 != (b2 & 0xC0) || 128 != (b3 & 0xC0) || 128 != (b4 & 0xC0)) {
            return true;
        }
        int codePoint = (((b1 & 7) << 6 | b2 & 0x3F) << 6 | b3 & 0x3F) << 6 | b4 & 0x3F;
        return 65536 > codePoint || 0x10FFFF < codePoint;
    }
}

