/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.tlv;

import de.gematik.smartcards.tlv.PrimitiveSpecific;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Optional;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "SF_SWITCH_NO_DEFAULT"})
public final class DerUtcTime
extends PrimitiveSpecific<ZonedDateTime> {
    public static final int TAG = 23;
    static final ZoneId UTC_TIME_ZONE = ZoneId.of("Z");
    final ZonedDateTime insDecoded;

    public DerUtcTime(ZonedDateTime value, UtcTimeFormat formatter) {
        super(23L, DerUtcTime.fromDateTime(value, formatter).getBytes(StandardCharsets.US_ASCII));
        this.insDecoded = (ZonedDateTime)this.fromValueField().orElseThrow();
    }

    DerUtcTime(ByteBuffer buffer) {
        super(new byte[]{23}, buffer);
        Optional<?> dateTime = this.fromValueField();
        if (dateTime.isEmpty()) {
            this.insFindings.add("wrong format");
            this.insDecoded = ZonedDateTime.now();
        } else {
            this.insDecoded = (ZonedDateTime)dateTime.get();
        }
    }

    DerUtcTime(InputStream inputStream) throws IOException {
        super(new byte[]{23}, inputStream);
        Optional<?> dateTime = this.fromValueField();
        if (dateTime.isEmpty()) {
            this.insFindings.add("wrong format");
            this.insDecoded = ZonedDateTime.now();
        } else {
            this.insDecoded = (ZonedDateTime)dateTime.get();
        }
    }

    static String fromDateTime(ZonedDateTime dateTime, UtcTimeFormat format) {
        ZonedDateTime result = dateTime;
        if (UtcTimeFormat.HH_MM_Z.equals((Object)format) || UtcTimeFormat.HH_MM_SS_Z.equals((Object)format)) {
            result = result.withZoneSameInstant(UTC_TIME_ZONE);
        }
        return result.format(format.getFormatter());
    }

    @Override
    public String getComment() {
        return " # UTCTime" + (this.isValid() ? " := " + String.valueOf(this.getDecoded()) : this.getFindings() + ", value-field as UTF-8: " + new String(this.insValueField, StandardCharsets.UTF_8));
    }

    @Override
    public ZonedDateTime getDecoded() {
        return this.insDecoded;
    }

    private Optional<?> fromValueField() {
        String input = new String(this.insValueField, StandardCharsets.US_ASCII);
        return Arrays.stream(UtcTimeFormat.values()).map(format -> {
            try {
                return Optional.of(ZonedDateTime.parse(input, format.getFormatter()));
            }
            catch (DateTimeParseException e) {
                return Optional.empty();
            }
        }).filter(Optional::isPresent).map(Optional::get).findAny();
    }

    public static enum UtcTimeFormat {
        HH_MM_Z("yyMMddHHmmVV"),
        HH_MM_SS_Z("yyMMddHHmmssVV"),
        HH_MM_DIFF("yyMMddHHmmxx"),
        HH_MM_SS_DIFF("yyMMddHHmmssxx");

        private final String insFormatter;

        private UtcTimeFormat(String format) {
            this.insFormatter = format;
        }

        public DateTimeFormatter getFormatter() {
            return DateTimeFormatter.ofPattern(this.insFormatter);
        }
    }
}

