/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.tlv;

import de.gematik.smartcards.tlv.DerRestrictedCharacterStringTypes;
import de.gematik.smartcards.utils.Hex;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public final class DerTeletexString
extends DerRestrictedCharacterStringTypes {
    public static final int TAG = 20;
    static final int[][] TRANSLATION = new int[][]{{8}, {10}, {12}, {13}, {14}, {15}, {26}, {32}, {33}, {34}, {93}, {95}, {124}, {160}, {161}, {162}, {163}, {164, 36}, {165}, {166, 35}, {167}, {168, 49828}, {171}, {176}, {177}, {178}, {179}, {180, 49879}, {181}, {182}, {183}, {184, 49911}, {187}, {188}, {189}, {190}, {191}, {224, 8486}, {225, 198}, {226, 208}, {227, 170}, {228, 294}, {230, 306}, {231, 319}, {232, 321}, {233, 216}, {234, 338}, {235, 186}, {236, 222}, {237, 358}, {238, 330}, {239, 329}, {240, 312}, {241, 230}, {242, 273}, {243, 240}, {244, 295}, {245, 305}, {246, 307}, {247, 320}, {248, 322}, {249, 248}, {250, 339}, {251, 223}, {252, 254}, {253, 359}, {254, 328}};
    static final List<Integer> T61 = new ArrayList<Integer>();
    static final List<Integer> UNICODE = new ArrayList<Integer>();

    public DerTeletexString(String value) {
        super(20, value);
    }

    DerTeletexString(ByteBuffer buffer) {
        super(new byte[]{20}, buffer);
    }

    DerTeletexString(InputStream inputStream) throws IOException {
        super(new byte[]{20}, inputStream);
    }

    @Override
    String fromBytes(byte[] octets) {
        try {
            StringBuilder result = new StringBuilder();
            ByteBuffer buffer = ByteBuffer.wrap(octets);
            while (buffer.hasRemaining()) {
                int t61 = buffer.get() & 0xFF;
                if (192 <= t61 && t61 <= 207) {
                    t61 = (t61 << 8) + (buffer.get() & 0xFF);
                }
                int index = T61.indexOf(t61);
                try {
                    int unicode = UNICODE.get(index);
                    result.appendCodePoint(unicode);
                }
                catch (IndexOutOfBoundsException ei) {
                    result.append('\u2022');
                }
            }
            return result.toString();
        }
        catch (BufferUnderflowException e) {
            throw new IllegalArgumentException("invalid characters", e);
        }
    }

    @Override
    public String getComment() {
        return this.getComment("TeletexString");
    }

    @Override
    boolean invalidCharacters() {
        return this.insDecoded.codePoints().anyMatch(codePoint -> !UNICODE.contains(codePoint));
    }

    static byte[] toBytes(String value) {
        StringBuilder result = new StringBuilder();
        value.codePoints().forEach(codePoint -> {
            try {
                int index = UNICODE.indexOf(codePoint);
                int t61 = T61.get(index);
                result.append(String.format(t61 > 255 ? "%04x" : "%02x", t61));
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("invalid characters", e);
            }
        });
        return Hex.toByteArray((CharSequence)result.toString());
    }

    static {
        IntStream.rangeClosed(37, 91).forEach(character -> {
            T61.add(character);
            UNICODE.add(character);
        });
        IntStream.rangeClosed(97, 122).forEach(character -> {
            T61.add(character);
            UNICODE.add(character);
        });
        for (int[] character2 : TRANSLATION) {
            int t61 = character2[0];
            int uni = character2.length < 2 ? t61 : character2[1];
            T61.add(t61);
            UNICODE.add(uni);
        }
        Map.ofEntries(Map.entry(193, List.of("AEIOUaeiou", "\u00c0\u00c8\u00cc\u00d2\u00d9\u00e0\u00e8\u00ec\u00f2\u00f9")), Map.entry(194, List.of("ACEILNORSUYZacegilnorsuyz", "\u00c1\u0106\u00c9\u00cd\u0139\u0143\u00d3\u0154\u015a\u00da\u00dd\u0179\u00e1\u0107\u00e9\u0123\u00ed\u013a\u0144\u00f3\u0155\u015b\u00fa\u00fd\u017a")), Map.entry(195, List.of("ACEGHIJOSUWYaceghijosuwy", "\u00c2\u0108\u00ca\u011c\u0124\u00ce\u0134\u00d4\u015c\u00db\u0174\u0176\u00e2\u0109\u00ea\u011d\u0125\u00ee\u0135\u00f4\u015d\u00fb\u0175\u0177")), Map.entry(196, List.of("AINOUainou", "\u00c3\u0128\u00d1\u00d5\u0168\u00e3\u0129\u00f1\u00f5\u0169")), Map.entry(197, List.of("AEIOUaeiou", "\u0100\u0112\u012a\u014c\u016a\u0101\u0113\u012b\u014d\u016b")), Map.entry(198, List.of("AGUagu", "\u0102\u011e\u016c\u0103\u011f\u016d")), Map.entry(199, List.of("CEGIZcegz", "\u010a\u0116\u0120\u0130\u017b\u010b\u0117\u0121\u017c")), Map.entry(200, List.of("AEIOUYaeiouy", "\u00c4\u00cb\u00cf\u00d6\u00dc\u0178\u00e4\u00eb\u00ef\u00f6\u00fc\u00ff")), Map.entry(202, List.of("AUau", "\u00c5\u016e\u00e5\u016f")), Map.entry(203, List.of("CGKLNRSTcklnrst", "\u00c7\u0122\u0136\u013b\u0145\u0156\u015e\u0162\u00e7\u0137\u013c\u0146\u0157\u015f\u0163")), Map.entry(205, List.of("OUou", "\u0150\u0170\u0151\u0171")), Map.entry(206, List.of("AEIUaeiu", "\u0104\u0118\u012e\u0172\u0105\u0119\u012f\u0173")), Map.entry(207, List.of("CDELNRSTZcdelnrstz", "\u010c\u010e\u011a\u013d\u0147\u0158\u0160\u0164\u017d\u010d\u010f\u011b\u013e\u0148\u0159\u0161\u0165\u017e"))).forEach((msByte, list) -> {
            int[] secondCharacter = ((String)list.get(0)).codePoints().toArray();
            int[] unicode = ((String)list.get(1)).codePoints().toArray();
            for (int i = 0; i < secondCharacter.length; ++i) {
                T61.add((msByte << 8) + secondCharacter[i]);
                UNICODE.add(unicode[i]);
            }
        });
    }
}

