/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.tlv;

import de.gematik.smartcards.tlv.BerTlv;
import de.gematik.smartcards.tlv.ClassOfTag;
import de.gematik.smartcards.tlv.ConstructedBerTlv;
import de.gematik.smartcards.tlv.DerSpecific;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.VisibleForTesting;

public final class DerSet
extends ConstructedBerTlv
implements DerSpecific {
    public static final int TAG = 49;
    final List<String> insFindings = new ArrayList<String>();

    public DerSet(Collection<? extends BerTlv> value) {
        super(49L, DerSet.sort(value));
        if (value.size() != this.getTemplate().size()) {
            throw new IllegalArgumentException("some tags occur more than once");
        }
    }

    DerSet(ByteBuffer buffer) {
        super(new byte[]{49}, buffer);
        this.check();
    }

    DerSet(InputStream inputStream) throws IOException {
        super(new byte[]{49}, inputStream);
        this.check();
    }

    private void check() {
        List<BerTlv> sorted = DerSet.sort(this.getTemplate());
        if (sorted.size() == this.getTemplate().size()) {
            if (!sorted.equals(this.getTemplate())) {
                this.insFindings.add("tags not correctly sorted");
            }
        } else {
            this.insFindings.add("tags not mutual exclusive");
        }
    }

    @VisibleForTesting
    static List<BerTlv> sort(Collection<? extends BerTlv> collection) {
        ArrayList<BerTlv> result = new ArrayList<BerTlv>();
        for (ClassOfTag clazz : ClassOfTag.values()) {
            collection.stream().filter(tlv -> clazz.equals((Object)tlv.getClassOfTag())).map(BerTlv::getTag).distinct().sorted().forEach(tag -> result.add(collection.stream().filter(tlv -> tag.longValue() == tlv.getTag()).findFirst().orElseThrow()));
        }
        return result;
    }

    @Override
    public DerSet add(BerTlv tlv) {
        if (this.get(tlv.getTag()).isPresent()) {
            throw new IllegalArgumentException("tag already present");
        }
        ArrayList<BerTlv> valueField = new ArrayList<BerTlv>(this.insValueField);
        valueField.add(tlv);
        return new DerSet(valueField);
    }

    @Override
    public String getComment() {
        int noElements;
        String result = " # SET with " + noElements + (1 == (noElements = this.insValueField.size()) ? " element" : " elements");
        if (!this.insFindings.isEmpty()) {
            result = result + this.insFindings.stream().collect(Collectors.joining(", ", ", findings: ", ""));
        }
        return result;
    }

    public List<BerTlv> getDecoded() {
        return this.getTemplate();
    }

    @Override
    public boolean isValid() {
        return this.insFindings.isEmpty();
    }
}

