/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.tlv;

import de.gematik.smartcards.tlv.DerIa5String;
import de.gematik.smartcards.tlv.DerPrintableString;
import de.gematik.smartcards.tlv.DerTeletexString;
import de.gematik.smartcards.tlv.PrimitiveSpecific;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

@SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW", "MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"})
public abstract class DerRestrictedCharacterStringTypes
extends PrimitiveSpecific<String> {
    static final String MESSAGE = "invalid characters";
    final String insDecoded;

    DerRestrictedCharacterStringTypes(int tag, String value) {
        super((long)tag, DerRestrictedCharacterStringTypes.toBytes(tag, value));
        this.insDecoded = value;
        if (this.invalidCharacters()) {
            throw new IllegalArgumentException(MESSAGE);
        }
    }

    DerRestrictedCharacterStringTypes(byte[] tag, ByteBuffer buffer) {
        super(tag, buffer);
        this.insDecoded = this.fromBytes(this.insValueField);
        this.check();
    }

    DerRestrictedCharacterStringTypes(byte[] tag, InputStream inputStream) throws IOException {
        super(tag, inputStream);
        this.insDecoded = this.fromBytes(this.insValueField);
        this.check();
    }

    private void check() {
        if (this.invalidCharacters()) {
            this.insFindings.add(MESSAGE);
        }
    }

    abstract String fromBytes(byte[] var1);

    final String getComment(String type) {
        return " # " + type + " := \"" + this.getDecoded() + "\"" + this.getFindings();
    }

    @Override
    public final String getDecoded() {
        return this.insDecoded;
    }

    abstract boolean invalidCharacters();

    static byte[] toBytes(int tag, String value) {
        return switch (tag) {
            case 22 -> DerIa5String.toBytes(value);
            case 19 -> DerPrintableString.toBytes(value);
            case 20 -> DerTeletexString.toBytes(value);
            default -> throw new IllegalArgumentException(String.format("tag = '%x' not (yet) implemented", tag));
        };
    }
}

