/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.tlv;

import de.gematik.smartcards.tlv.PrimitiveSpecific;
import de.gematik.smartcards.utils.AfiOid;
import de.gematik.smartcards.utils.Hex;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public final class DerOid
extends PrimitiveSpecific<AfiOid> {
    public static final int TAG = 6;
    final AfiOid insDecoded;

    public DerOid(AfiOid value) {
        super(6L, Hex.toByteArray((CharSequence)value.getOctetString()));
        this.insDecoded = value;
    }

    DerOid(ByteBuffer buffer) {
        super(new byte[]{6}, buffer);
        AfiOid decoded;
        try {
            decoded = new AfiOid(this.insValueField);
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            decoded = AfiOid.INVALID;
            this.insFindings.add("invalid OID");
        }
        this.insDecoded = decoded;
    }

    DerOid(InputStream inputStream) throws IOException {
        super(new byte[]{6}, inputStream);
        AfiOid decoded;
        try {
            decoded = new AfiOid(this.insValueField);
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            decoded = AfiOid.INVALID;
            this.insFindings.add("invalid OID");
        }
        this.insDecoded = decoded;
    }

    @Override
    public String getComment() {
        String name;
        String point = this.insDecoded.getPoint();
        return " # OBJECT IDENTIFIER := " + name + (String)((name = this.insDecoded.getName()).equals(point) ? "" : " = " + point);
    }

    @Override
    public AfiOid getDecoded() {
        return this.insDecoded;
    }
}

