/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.tlv;

import de.gematik.smartcards.tlv.PrimitiveSpecific;
import de.gematik.smartcards.utils.AfiUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class DerNull
extends PrimitiveSpecific<String> {
    private static final String COMMENT = " # NULL";
    public static final int TAG = 5;
    public static final DerNull NULL = new DerNull();

    private DerNull() {
        super(5L, AfiUtils.EMPTY_OS);
    }

    private DerNull(ByteBuffer buffer) {
        super(new byte[]{5}, buffer);
        this.check();
    }

    private DerNull(InputStream inputStream) throws IOException {
        super(new byte[]{5}, inputStream);
        this.check();
    }

    private void check() {
        if (0L != this.getLengthOfValueField()) {
            this.insFindings.add("value-field present");
        } else if (1 != this.insLengthOfLengthFieldFromStream) {
            this.insFindings.add("original length-field unequal to '00'");
        }
    }

    private static DerNull checkInstance(DerNull result) {
        if (result.insFindings.isEmpty()) {
            return NULL;
        }
        return result;
    }

    static DerNull readInstance(ByteBuffer buffer) {
        return DerNull.checkInstance(new DerNull(buffer));
    }

    static DerNull readInstance(InputStream inputStream) throws IOException {
        return DerNull.checkInstance(new DerNull(inputStream));
    }

    @Override
    public String getComment() {
        return COMMENT + this.getFindings();
    }

    @Override
    public String getDecoded() {
        return "";
    }
}

