/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.tlv;

import de.gematik.smartcards.tlv.PrimitiveSpecific;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.VisibleForTesting;

public final class DerInteger
extends PrimitiveSpecific<BigInteger> {
    public static final int TAG = 2;
    @VisibleForTesting
    static final String EM_9 = "9 MSBit all equal";
    @VisibleForTesting
    @Nullable
    volatile BigInteger insDecoded;

    public DerInteger(BigInteger value) {
        super(2L, value.toByteArray());
        this.insDecoded = value;
    }

    DerInteger(ByteBuffer buffer) {
        super(new byte[]{2}, buffer);
        this.check();
    }

    DerInteger(InputStream inputStream) throws IOException {
        super(new byte[]{2}, inputStream);
        this.check();
    }

    private void check() {
        if (0 == this.insValueField.length) {
            this.insFindings.add("value-field absent");
        }
        if (this.insValueField.length > 1 && (-1 == this.insValueField[0] && 128 == (this.insValueField[1] & 0x80) || 0 == this.insValueField[0] && 0 == (this.insValueField[1] & 0x80))) {
            this.insFindings.add(EM_9);
        }
    }

    @Override
    public String getComment() {
        return " # INTEGER := " + String.valueOf(this.getDecoded()) + this.getFindings();
    }

    @Override
    public BigInteger getDecoded() {
        BigInteger result = this.insDecoded;
        if (null == result) {
            this.insDecoded = result = 0 == this.insValueField.length ? BigInteger.ZERO : new BigInteger(this.insValueField);
        }
        return result;
    }
}

