/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.tlv;

import de.gematik.smartcards.tlv.DerRestrictedCharacterStringTypes;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;

public final class DerIa5String
extends DerRestrictedCharacterStringTypes {
    public static final int TAG = 22;
    static final List<Integer> IA5 = new ArrayList<Integer>();
    static final List<Integer> UNICODE = new ArrayList<Integer>();

    public DerIa5String(String value) {
        super(22, value);
    }

    DerIa5String(ByteBuffer buffer) {
        super(new byte[]{22}, buffer);
    }

    DerIa5String(InputStream inputStream) throws IOException {
        super(new byte[]{22}, inputStream);
    }

    @Override
    String fromBytes(byte[] octets) {
        StringBuilder result = new StringBuilder();
        ByteBuffer buffer = ByteBuffer.wrap(octets);
        while (buffer.hasRemaining()) {
            int ia5 = buffer.get() & 0xFF;
            int index = IA5.indexOf(ia5);
            int unicode = UNICODE.get(index);
            result.appendCodePoint(unicode);
        }
        return result.toString();
    }

    @Override
    public String getComment() {
        return this.getComment("IA5String");
    }

    @Override
    boolean invalidCharacters() {
        return false;
    }

    static byte[] toBytes(String value) {
        byte[] result = new byte[value.length()];
        try {
            int i = result.length;
            while (i-- > 0) {
                int codePoint = value.codePointAt(i);
                int index = UNICODE.indexOf(codePoint);
                int ia5 = IA5.get(index);
                result[i] = (byte)ia5;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid characters", e);
        }
        return result;
    }

    static {
        IntStream.rangeClosed(0, 255).forEach(codePoint -> {
            IA5.add(codePoint);
            switch (codePoint) {
                case 64: {
                    UNICODE.add(167);
                    break;
                }
                case 91: {
                    UNICODE.add(196);
                    break;
                }
                case 92: {
                    UNICODE.add(214);
                    break;
                }
                case 93: {
                    UNICODE.add(220);
                    break;
                }
                case 123: {
                    UNICODE.add(228);
                    break;
                }
                case 124: {
                    UNICODE.add(246);
                    break;
                }
                case 125: {
                    UNICODE.add(252);
                    break;
                }
                case 126: {
                    UNICODE.add(223);
                    break;
                }
                default: {
                    UNICODE.add(codePoint);
                }
            }
        });
    }
}

