/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.tlv;

import de.gematik.smartcards.tlv.PrimitiveSpecific;
import de.gematik.smartcards.utils.Hex;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.jetbrains.annotations.VisibleForTesting;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public final class DerDate
extends PrimitiveSpecific<LocalDate> {
    public static final int TAG = 7967;
    @VisibleForTesting
    static final byte[] TAG_FIELD = Hex.toByteArray((CharSequence)String.format("%x", 7967));
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.BASIC_ISO_DATE;
    static final Charset CHARSET = StandardCharsets.UTF_8;
    final LocalDate insDecoded;

    public DerDate(LocalDate value) {
        super(7967L, value.format(FORMATTER).getBytes(CHARSET));
        this.insDecoded = value;
    }

    DerDate(ByteBuffer buffer) {
        super(TAG_FIELD, buffer);
        LocalDate date;
        try {
            date = LocalDate.parse(new String(this.insValueField, CHARSET), FORMATTER);
        }
        catch (DateTimeParseException e) {
            this.insFindings.add("wrong format");
            date = LocalDate.now();
        }
        this.insDecoded = date;
    }

    DerDate(InputStream inputStream) throws IOException {
        super(TAG_FIELD, inputStream);
        LocalDate date;
        try {
            date = LocalDate.parse(new String(this.insValueField, CHARSET), FORMATTER);
        }
        catch (DateTimeParseException e) {
            this.insFindings.add("wrong format");
            date = LocalDate.now();
        }
        this.insDecoded = date;
    }

    @Override
    public String getComment() {
        return " # DATE" + (this.isValid() ? " := " + String.valueOf(this.getDecoded()) : this.getFindings() + ", value-field as UTF-8: " + new String(this.insValueField, CHARSET));
    }

    @Override
    public LocalDate getDecoded() {
        return this.insDecoded;
    }
}

