/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.tlv;

import de.gematik.smartcards.tlv.PrimitiveSpecific;
import de.gematik.smartcards.utils.Hex;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.VisibleForTesting;

public final class DerBoolean
extends PrimitiveSpecific<Boolean> {
    public static final int TAG = 1;
    public static final DerBoolean TRUE = DerBoolean.create(true);
    public static final DerBoolean FALSE = DerBoolean.create(false);
    private final boolean insDecoded;

    private DerBoolean(ByteBuffer buffer) {
        super(new byte[]{1}, buffer);
        this.insDecoded = this.insValueField.length > 0 && 0 != this.insValueField[0];
        this.check();
    }

    private DerBoolean(InputStream inputStream) throws IOException {
        super(new byte[]{1}, inputStream);
        this.insDecoded = this.insValueField.length > 0 && 0 != this.insValueField[0];
        this.check();
    }

    private void check() {
        if (1L != this.getLengthOfValueField()) {
            this.insFindings.add("length of value-field unequal to 1");
        } else if (1 != this.insLengthOfLengthFieldFromStream) {
            this.insFindings.add("original length-field unequal to '01'");
        }
    }

    private static DerBoolean checkInstance(DerBoolean result) {
        if (result.isValid()) {
            if (result.getDecoded().booleanValue()) {
                return -1 == result.insValueField[0] ? TRUE : result;
            }
            return FALSE;
        }
        return result;
    }

    static DerBoolean readInstance(ByteBuffer buffer) {
        return DerBoolean.checkInstance(new DerBoolean(buffer));
    }

    static DerBoolean readInstance(InputStream inputStream) throws IOException {
        return DerBoolean.checkInstance(new DerBoolean(inputStream));
    }

    private static DerBoolean create(boolean value) {
        return DerBoolean.create(String.format("-01-%02x", value ? 255 : 0));
    }

    @VisibleForTesting
    static DerBoolean create(String octets) {
        try {
            return new DerBoolean(new ByteArrayInputStream(Hex.toByteArray((CharSequence)octets)));
        }
        catch (IOException | IllegalArgumentException e) {
            throw new IllegalStateException("initialization failed", e);
        }
    }

    @Override
    public String getComment() {
        return " # BOOLEAN := " + this.getDecoded() + this.getFindings();
    }

    @Override
    public Boolean getDecoded() {
        return this.insDecoded;
    }
}

