/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.tlv;

import de.gematik.smartcards.tlv.PrimitiveSpecific;
import de.gematik.smartcards.utils.AfiUtils;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.VisibleForTesting;

public final class DerBitString
extends PrimitiveSpecific<byte[]> {
    public static final int TAG = 3;
    @VisibleForTesting
    static final String EM_7 = "numberOfUnusedBits greater than 7";
    @VisibleForTesting
    static final String EM_GT0 = "numberOfUnusedBits greater than zero but empty bit-string";
    final int insNumberOfUnusedBits;
    @Nullable
    volatile String insBitString;
    @Nullable
    byte[] insDecoded;

    public DerBitString(byte[] value) {
        this(0, value);
    }

    public DerBitString(int numberOfUnusedBits, byte[] value) {
        super(3L, AfiUtils.concatenate((byte[][])new byte[][]{{(byte)numberOfUnusedBits}, value}));
        this.insNumberOfUnusedBits = numberOfUnusedBits;
        this.insDecoded = (byte[])value.clone();
        if (0 > this.insNumberOfUnusedBits || this.insNumberOfUnusedBits > 7) {
            throw new IllegalArgumentException("numberOfUnusedBits out of range [0, 7]");
        }
        if (0 != this.insNumberOfUnusedBits && 1L == this.getLengthOfValueField()) {
            throw new IllegalArgumentException(EM_GT0);
        }
    }

    DerBitString(ByteBuffer buffer) {
        super(new byte[]{3}, buffer);
        this.insNumberOfUnusedBits = 0 == this.insValueField.length ? 0 : this.insValueField[0] & 0xFF;
        this.check();
    }

    DerBitString(InputStream inputStream) throws IOException {
        super(new byte[]{3}, inputStream);
        this.insNumberOfUnusedBits = 0 == this.insValueField.length ? 0 : this.insValueField[0] & 0xFF;
        this.check();
    }

    private void check() {
        if (0 == this.insValueField.length) {
            this.insFindings.add("value-field absent");
        } else if (this.insNumberOfUnusedBits > 7) {
            this.insFindings.add(EM_7);
        } else if (0 != this.insNumberOfUnusedBits && 1L == this.getLengthOfValueField()) {
            this.insFindings.add(EM_GT0);
        }
    }

    String getBitString() {
        String result = this.insBitString;
        if (null == result) {
            this.insBitString = result = DerBitString.toBitString(this.getNumberOfUnusedBits(), this.getDecoded());
        }
        return result;
    }

    @Override
    public String getComment() {
        int noUnusedBits = this.getNumberOfUnusedBits();
        return String.format(" # BITSTRING: %d unused bit%s: '%s'%s", noUnusedBits, 1 == noUnusedBits ? "" : "s", this.getBitString(), this.getFindings());
    }

    @Override
    public byte[] getDecoded() {
        byte[] result = this.insDecoded;
        if (null == result) {
            result = 0 == this.insValueField.length ? AfiUtils.EMPTY_OS : Arrays.copyOfRange(this.insValueField, 1, (int)this.getLengthOfValueField());
            this.insDecoded = result;
        }
        return (byte[])result.clone();
    }

    public int getNumberOfUnusedBits() {
        return this.insNumberOfUnusedBits;
    }

    static String toBitString(int noUnusedBits, byte[] octets) {
        int noUsedBits = (octets.length << 3) - noUnusedBits;
        if (noUsedBits <= 0) {
            return "";
        }
        BigInteger number = new BigInteger(1, octets).shiftRight(noUnusedBits);
        StringBuilder result = new StringBuilder();
        int counter = 0;
        while (noUsedBits > 0) {
            if (0 == counter++ % 8) {
                result.append(' ');
            }
            result.append(number.testBit(--noUsedBits) ? (char)'1' : '0');
        }
        return result.toString().trim();
    }

    @Override
    @VisibleForTesting
    String toString(String delimiter, String delo, int noIndentation, boolean addComment) {
        StringBuilder result = new StringBuilder(super.toString(delimiter, delo, noIndentation, addComment));
        if (addComment && 0 == this.getNumberOfUnusedBits()) {
            result.append(this.commentDecoded(noIndentation, this.getDecoded()));
        }
        return result.toString();
    }
}

