/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.tlv;

import de.gematik.smartcards.tlv.BerTlv;
import de.gematik.smartcards.tlv.ClassOfTag;
import de.gematik.smartcards.tlv.DerBitString;
import de.gematik.smartcards.tlv.DerBoolean;
import de.gematik.smartcards.tlv.DerDate;
import de.gematik.smartcards.tlv.DerEndOfContent;
import de.gematik.smartcards.tlv.DerIa5String;
import de.gematik.smartcards.tlv.DerInteger;
import de.gematik.smartcards.tlv.DerNull;
import de.gematik.smartcards.tlv.DerOctetString;
import de.gematik.smartcards.tlv.DerOid;
import de.gematik.smartcards.tlv.DerPrintableString;
import de.gematik.smartcards.tlv.DerSequence;
import de.gematik.smartcards.tlv.DerSet;
import de.gematik.smartcards.tlv.DerTeletexString;
import de.gematik.smartcards.tlv.DerUtcTime;
import de.gematik.smartcards.tlv.DerUtf8String;
import de.gematik.smartcards.tlv.PrimitiveBerTlv;
import de.gematik.smartcards.utils.Hex;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.VisibleForTesting;

@SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW", "EI_EXPOSE_REP"})
public class ConstructedBerTlv
extends BerTlv {
    @VisibleForTesting
    static final String EMP = "tag-field indicates primitive encoding";
    final List<BerTlv> insValueField;

    ConstructedBerTlv(byte[] tag, ByteBuffer buffer) {
        super(tag, buffer);
        this.checkTag();
        ArrayList<BerTlv> value = new ArrayList<BerTlv>();
        if (this.insIndefiniteForm) {
            while (true) {
                BerTlv tlv = ConstructedBerTlv.getFromBuffer(buffer);
                this.insLengthOfValueFieldFromStream += (long)(tlv.getLengthOfTagField() + tlv.insLengthOfLengthFieldFromStream) + tlv.insLengthOfValueFieldFromStream;
                if (!(tlv instanceof DerEndOfContent)) {
                    value.add(tlv);
                    continue;
                }
                break;
            }
        } else {
            BerTlv tlv;
            for (long length = this.insLengthOfValueFieldFromStream; length > 0L; length -= (long)(tlv.getLengthOfTagField() + tlv.insLengthOfLengthFieldFromStream) + tlv.insLengthOfValueFieldFromStream) {
                tlv = ConstructedBerTlv.getFromBuffer(buffer);
                value.add(tlv);
            }
        }
        this.insValueField = List.copyOf(value);
        this.insLengthOfValueField = this.insValueField.stream().mapToLong(BerTlv::getLengthOfTlvObject).sum();
        int minLengthOfLf = ConstructedBerTlv.calculateLengthOfLengthField(this.insLengthOfValueField);
        int lengthOfTagField = this.getLengthOfTagField();
        byte[] tagLengthField = new byte[lengthOfTagField + minLengthOfLf];
        System.arraycopy(this.insTagLengthField, 0, tagLengthField, 0, lengthOfTagField);
        byte[] lf = Hex.toByteArray((CharSequence)ConstructedBerTlv.getLengthField(this.insLengthOfValueField));
        System.arraycopy(lf, 0, tagLengthField, lengthOfTagField, minLengthOfLf);
        this.insTagLengthField = tagLengthField;
    }

    ConstructedBerTlv(byte[] tag, InputStream inputStream) throws IOException {
        super(tag, inputStream);
        this.checkTag();
        ArrayList<BerTlv> value = new ArrayList<BerTlv>();
        if (this.insIndefiniteForm) {
            while (true) {
                BerTlv tlv = ConstructedBerTlv.getInstance(inputStream);
                this.insLengthOfValueFieldFromStream += (long)(tlv.getLengthOfTagField() + tlv.insLengthOfLengthFieldFromStream) + tlv.insLengthOfValueFieldFromStream;
                if (!(tlv instanceof DerEndOfContent)) {
                    value.add(tlv);
                    continue;
                }
                break;
            }
        } else {
            BerTlv tlv;
            for (long length = this.insLengthOfValueFieldFromStream; length > 0L; length -= (long)(tlv.getLengthOfTagField() + tlv.insLengthOfLengthFieldFromStream) + tlv.insLengthOfValueFieldFromStream) {
                tlv = ConstructedBerTlv.getInstance(inputStream);
                value.add(tlv);
            }
        }
        this.insValueField = List.copyOf(value);
        this.insLengthOfValueField = this.insValueField.stream().mapToLong(BerTlv::getLengthOfTlvObject).sum();
        int minLengthOfLf = ConstructedBerTlv.calculateLengthOfLengthField(this.insLengthOfValueField);
        int lengthOfTagField = this.getLengthOfTagField();
        byte[] tagLengthField = new byte[lengthOfTagField + minLengthOfLf];
        System.arraycopy(this.insTagLengthField, 0, tagLengthField, 0, lengthOfTagField);
        byte[] lf = Hex.toByteArray((CharSequence)ConstructedBerTlv.getLengthField(this.insLengthOfValueField));
        System.arraycopy(lf, 0, tagLengthField, lengthOfTagField, minLengthOfLf);
        this.insTagLengthField = tagLengthField;
    }

    ConstructedBerTlv(long tag, byte[] value) {
        super(tag, 0L);
        this.checkTag();
        ArrayList<BerTlv> valueField = new ArrayList<BerTlv>();
        ByteArrayInputStream bais = new ByteArrayInputStream(value);
        while (bais.available() > 0) {
            valueField.add(ConstructedBerTlv.getInstance(bais));
        }
        this.insValueField = List.copyOf(valueField);
        this.insLengthOfValueField = this.insValueField.stream().mapToLong(BerTlv::getLengthOfTlvObject).sum();
        int minLengthOfLf = ConstructedBerTlv.calculateLengthOfLengthField(this.insLengthOfValueField);
        int lengthOfTagField = this.getLengthOfTagField();
        byte[] tagLengthField = new byte[lengthOfTagField + minLengthOfLf];
        System.arraycopy(this.insTagLengthField, 0, tagLengthField, 0, lengthOfTagField);
        byte[] lf = Hex.toByteArray((CharSequence)ConstructedBerTlv.getLengthField(this.insLengthOfValueField));
        System.arraycopy(lf, 0, tagLengthField, lengthOfTagField, minLengthOfLf);
        this.insTagLengthField = tagLengthField;
    }

    ConstructedBerTlv(long tag, Collection<? extends BerTlv> value) {
        super(tag, value.stream().map(tlv -> BigInteger.valueOf(tlv.getLengthOfTlvObject())).reduce(BigInteger::add).orElse(BigInteger.ZERO).longValueExact());
        this.checkTag();
        this.insValueField = List.copyOf(value);
        this.insLengthOfValueField = this.insValueField.stream().mapToLong(BerTlv::getLengthOfTlvObject).sum();
    }

    public ConstructedBerTlv add(BerTlv tlv) {
        ArrayList<BerTlv> valueField = new ArrayList<BerTlv>(this.insValueField);
        valueField.add(tlv);
        return new ConstructedBerTlv(this.getTag(), valueField);
    }

    private void checkTag() {
        if (32 != (this.insTagLengthField[0] & 0x20)) {
            throw new IllegalArgumentException(EMP);
        }
    }

    public static byte[] createTag(ClassOfTag classOfTag, long number) {
        return ConstructedBerTlv.createTag(classOfTag, true, number);
    }

    @Override
    public final boolean equals(@CheckForNull Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ConstructedBerTlv other = (ConstructedBerTlv)obj;
        return this.insValueField.equals(other.insValueField);
    }

    @Override
    public final int hashCode() {
        int result = this.insHashCode;
        if (0 == result) {
            result = super.hashCode();
            int hashCodeMultiplier = 31;
            for (BerTlv i : this.insValueField) {
                result = result * 31 + i.hashCode();
            }
            this.insHashCode = result;
        }
        return result;
    }

    public final Optional<BerTlv> get(long tag) {
        return this.get(tag, 0);
    }

    public final Optional<BerTlv> get(long tag, int position) {
        for (BerTlv i : this.insValueField) {
            if (i.getTag() != tag || position-- > 0) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public final Optional<ConstructedBerTlv> getConstructed(long tag) {
        return this.getConstructed(tag, 0);
    }

    public final Optional<ConstructedBerTlv> getConstructed(long tag, int position) {
        return this.get(tag, position).map(ConstructedBerTlv.class::cast);
    }

    public final Optional<PrimitiveBerTlv> getPrimitive(long tag) {
        return this.getPrimitive(tag, 0);
    }

    public final Optional<PrimitiveBerTlv> getPrimitive(long tag, int position) {
        return this.get(tag, position).map(PrimitiveBerTlv.class::cast);
    }

    public final List<BerTlv> getTemplate() {
        return this.insValueField;
    }

    @Override
    public final byte[] getValueField() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)this.getLengthOfValueField());
        for (BerTlv tlv : this.insValueField) {
            tlv.getEncoded(baos);
        }
        return baos.toByteArray();
    }

    public final DerBitString getBitString() {
        return this.getBitString(0);
    }

    public final DerBitString getBitString(int position) {
        return (DerBitString)this.get(3L, position).orElseThrow();
    }

    public final DerBoolean getBoolean() {
        return this.getBoolean(0);
    }

    public final DerBoolean getBoolean(int position) {
        return (DerBoolean)this.get(1L, position).orElseThrow();
    }

    public final DerDate getDate() {
        return this.getDate(0);
    }

    public final DerDate getDate(int position) {
        return (DerDate)this.get(7967L, position).orElseThrow();
    }

    public final DerEndOfContent getEndOfContent() {
        return this.getEndOfContent(0);
    }

    public final DerEndOfContent getEndOfContent(int position) {
        return (DerEndOfContent)this.get(0L, position).orElseThrow();
    }

    public final DerIa5String getIa5String() {
        return this.getIa5String(0);
    }

    public final DerIa5String getIa5String(int position) {
        return (DerIa5String)this.get(22L, position).orElseThrow();
    }

    public final DerInteger getInteger() {
        return this.getInteger(0);
    }

    public final DerInteger getInteger(int position) {
        return (DerInteger)this.get(2L, position).orElseThrow();
    }

    public final DerNull getNull() {
        return this.getNull(0);
    }

    public final DerNull getNull(int position) {
        return (DerNull)this.get(5L, position).orElseThrow();
    }

    public final DerOctetString getOctetString() {
        return this.getOctetString(0);
    }

    public final DerOctetString getOctetString(int position) {
        return (DerOctetString)this.get(4L, position).orElseThrow();
    }

    public final DerOid getOid() {
        return this.getOid(0);
    }

    public final DerOid getOid(int position) {
        return (DerOid)this.get(6L, position).orElseThrow();
    }

    public final DerPrintableString getPrintableString() {
        return this.getPrintableString(0);
    }

    public final DerPrintableString getPrintableString(int position) {
        return (DerPrintableString)this.get(19L, position).orElseThrow();
    }

    public final DerSequence getSequence() {
        return this.getSequence(0);
    }

    public final DerSequence getSequence(int position) {
        return (DerSequence)this.get(48L, position).orElseThrow();
    }

    public final DerSet getSet() {
        return this.getSet(0);
    }

    public final DerSet getSet(int position) {
        return (DerSet)this.get(49L, position).orElseThrow();
    }

    public final DerTeletexString getTeletexString() {
        return this.getTeletexString(0);
    }

    public final DerTeletexString getTeletexString(int position) {
        return (DerTeletexString)this.get(20L, position).orElseThrow();
    }

    public final DerUtcTime getUtcTime() {
        return this.getUtcTime(0);
    }

    public final DerUtcTime getUtcTime(int position) {
        return (DerUtcTime)this.get(23L, position).orElseThrow();
    }

    public final DerUtf8String getUtf8String() {
        return this.getUtf8String(0);
    }

    public final DerUtf8String getUtf8String(int position) {
        return (DerUtf8String)this.get(12L, position).orElseThrow();
    }

    @Override
    public final byte[] getEncoded() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)this.getLengthOfTlvObject());
        this.getEncoded(baos);
        return baos.toByteArray();
    }

    @Override
    @VisibleForTesting
    final ByteArrayOutputStream getEncoded(ByteArrayOutputStream out) {
        super.getEncoded(out);
        for (BerTlv i : this.getTemplate()) {
            i.getEncoded(out);
        }
        return out;
    }

    public final String toString(String delimiter, String delo) {
        return this.toString(delimiter, delo, 0, false);
    }

    @Override
    final String toString(String delimiter, String delo, int noIndentation, boolean addComment) {
        String tagLength = this.tagLength2String(delimiter, delo, noIndentation).toString();
        if (delo.isEmpty()) {
            return tagLength + this.insValueField.parallelStream().map(tlv -> String.format("%s%s%s", delimiter, delimiter, tlv.toString(delimiter))).collect(Collectors.joining());
        }
        String comment = addComment ? this.getComment() : "";
        return tagLength + comment + this.insValueField.parallelStream().map(tlv -> String.format("%n%s", tlv.toString(delimiter, delo, noIndentation + 1, addComment))).collect(Collectors.joining());
    }
}

