/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.tlv;

import de.gematik.smartcards.tlv.ClassOfTag;
import de.gematik.smartcards.tlv.ConstructedBerTlv;
import de.gematik.smartcards.tlv.DerBitString;
import de.gematik.smartcards.tlv.DerBoolean;
import de.gematik.smartcards.tlv.DerDate;
import de.gematik.smartcards.tlv.DerEndOfContent;
import de.gematik.smartcards.tlv.DerIa5String;
import de.gematik.smartcards.tlv.DerInteger;
import de.gematik.smartcards.tlv.DerNull;
import de.gematik.smartcards.tlv.DerOctetString;
import de.gematik.smartcards.tlv.DerOid;
import de.gematik.smartcards.tlv.DerPrintableString;
import de.gematik.smartcards.tlv.DerSequence;
import de.gematik.smartcards.tlv.DerSet;
import de.gematik.smartcards.tlv.DerTeletexString;
import de.gematik.smartcards.tlv.DerUtcTime;
import de.gematik.smartcards.tlv.DerUtf8String;
import de.gematik.smartcards.tlv.PrimitiveBerTlv;
import de.gematik.smartcards.utils.AfiUtils;
import de.gematik.smartcards.utils.Hex;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import org.jetbrains.annotations.VisibleForTesting;

@SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW", "DCN_NULLPOINTER_EXCEPTION"})
public abstract class BerTlv {
    static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    @VisibleForTesting
    static final int NO_TAG_FIELD = 8;
    final boolean insIndefiniteForm;
    final int insLengthOfLengthFieldFromStream;
    private final int insLengthOfTagField;
    private final long insTag;
    volatile int insHashCode;
    long insLengthOfValueField = -1L;
    long insLengthOfValueFieldFromStream;
    byte[] insTagLengthField;

    BerTlv(byte[] tag, ByteBuffer buffer) {
        BerTlv.checkTag(tag);
        long[] lengthInfo = BerTlv.readLength(buffer);
        long lenVfStream = lengthInfo[0];
        if (lenVfStream < 0L) {
            this.insIndefiniteForm = true;
            this.insLengthOfValueFieldFromStream = 0L;
        } else {
            this.insIndefiniteForm = false;
            this.insLengthOfValueFieldFromStream = lenVfStream;
        }
        byte[] lengthField = Hex.toByteArray((CharSequence)BerTlv.getLengthField(this.insLengthOfValueFieldFromStream));
        this.insLengthOfLengthFieldFromStream = (int)lengthInfo[1];
        this.insLengthOfTagField = tag.length;
        this.insTag = BerTlv.convertTag(tag);
        this.insTagLengthField = AfiUtils.concatenate((byte[][])new byte[][]{tag, lengthField});
    }

    BerTlv(byte[] tag, InputStream inputStream) throws IOException {
        BerTlv.checkTag(tag);
        long[] lengthInfo = BerTlv.readLength(inputStream);
        long lenVfStream = lengthInfo[0];
        if (lenVfStream < 0L) {
            this.insIndefiniteForm = true;
            this.insLengthOfValueFieldFromStream = 0L;
        } else {
            this.insIndefiniteForm = false;
            this.insLengthOfValueFieldFromStream = lenVfStream;
        }
        byte[] lengthField = Hex.toByteArray((CharSequence)BerTlv.getLengthField(this.insLengthOfValueFieldFromStream));
        this.insLengthOfLengthFieldFromStream = (int)lengthInfo[1];
        this.insLengthOfTagField = tag.length;
        this.insTag = BerTlv.convertTag(tag);
        this.insTagLengthField = AfiUtils.concatenate((byte[][])new byte[][]{tag, lengthField});
    }

    BerTlv(long tag, long lengthOfValueField) {
        byte[] tagField = BerTlv.convertTag(tag);
        BerTlv.checkTag(tagField);
        byte[] lengthField = Hex.toByteArray((CharSequence)BerTlv.getLengthField(lengthOfValueField));
        this.insLengthOfTagField = tagField.length;
        this.insTag = tag;
        this.insTagLengthField = AfiUtils.concatenate((byte[][])new byte[][]{tagField, lengthField});
        this.insIndefiniteForm = false;
        this.insLengthOfValueFieldFromStream = 0L;
        this.insLengthOfLengthFieldFromStream = 1;
    }

    public static BerTlv base64(String base64) {
        return BerTlv.getInstance(BASE64_DECODER.decode(base64));
    }

    static int calculateLengthOfLengthField(long lengthOfValueField) {
        if (lengthOfValueField < 0L) {
            return 9;
        }
        if (lengthOfValueField < 128L) {
            return 1;
        }
        int result = 2;
        while ((lengthOfValueField >>= 8) > 0L) {
            ++result;
        }
        return result;
    }

    @VisibleForTesting
    static void checkTag(byte[] tag) {
        if (0 == tag.length) {
            throw new IllegalArgumentException("empty tag-field");
        }
        if (1 == tag.length) {
            BerTlv.checkTag1(tag);
        } else {
            if (tag.length > 8) {
                throw new IllegalArgumentException("tag too long for this implementation");
            }
            BerTlv.checkTag2345678(tag);
        }
    }

    private static void checkTag1(byte[] tag) {
        if (31 == (tag[0] & 0x1F)) {
            throw new IllegalArgumentException("No subsequent octet in tag = '" + Hex.toHexDigits((byte[])tag) + "'");
        }
    }

    private static void checkTag2345678(byte[] tag) {
        if (0 == (tag[1] & 0x7F)) {
            throw new IllegalArgumentException("bits b7..b1 all zero in first subsequent octet of tag = '" + Hex.toHexDigits((byte[])tag) + "'");
        }
        if (2 == tag.length && (tag[1] & 0x7F) < 31) {
            throw new IllegalArgumentException("No need for two byte tag = '" + Hex.toHexDigits((byte[])tag) + "'");
        }
        if (31 != (tag[0] & 0x1F)) {
            throw new IllegalArgumentException("Leading octet wrong in tag = '" + Hex.toHexDigits((byte[])tag) + "'");
        }
        int k = tag.length - 1;
        while (k-- > 1) {
            if (tag[k] < 0) continue;
            throw new IllegalArgumentException("Intermediate byte has MS-bit not set in tag = '" + Hex.toHexDigits((byte[])tag) + "'");
        }
        if (tag[tag.length - 1] < 0) {
            throw new IllegalArgumentException("LS-byte has MS-bit set in tag = '" + Hex.toHexDigits((byte[])tag) + "'");
        }
    }

    static long convertTag(byte[] tag) {
        return (8 == tag.length ? new BigInteger(tag) : new BigInteger(1, tag)).longValueExact();
    }

    static byte[] convertTag(long tag) {
        String hexA = Long.toHexString(tag);
        String hexB = (1 == hexA.length() % 2 ? "0" : "") + hexA;
        return Hex.toByteArray((CharSequence)hexB);
    }

    static byte[] createTag(ClassOfTag classOfTag, boolean isConstructed, long number) {
        int b8b7b6 = classOfTag.getEncoding() + (isConstructed ? 32 : 0);
        if (number < 0L) {
            throw new IllegalArgumentException("number = " + number + " < 0");
        }
        if (number < 31L) {
            return new byte[]{(byte)((long)b8b7b6 + number)};
        }
        ArrayList<Byte> octet = new ArrayList<Byte>();
        while (number > 0L) {
            octet.addFirst((byte)(number & 0x7FL));
            number >>= 7;
        }
        int i = octet.size() - 1;
        while (i-- > 0) {
            octet.set(i, (byte)((Byte)octet.get(i) | 0x80));
        }
        octet.addFirst((byte)(b8b7b6 + 31));
        byte[] result = new byte[octet.size()];
        int i2 = result.length;
        while (i2-- > 0) {
            result[i2] = (Byte)octet.get(i2);
        }
        return result;
    }

    @VisibleForTesting
    static long numberOfTag(byte[] octets) {
        int mask = 31;
        int msByte = octets[0] & 0x1F;
        if (31 == msByte) {
            long result = 0L;
            int index = 1;
            while (true) {
                byte subsequentOctet = octets[index];
                result += (long)(subsequentOctet & 0x7F);
                if (subsequentOctet >= 0) break;
                result <<= 7;
                ++index;
            }
            return result;
        }
        return msByte;
    }

    public boolean equals(@CheckForNull Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BerTlv other = (BerTlv)obj;
        return this.insTag == other.insTag;
    }

    public int hashCode() {
        int hashCodeMultiplier = 31;
        int result = (int)(this.insTag >> 32);
        result = result * 31 + (int)this.insTag;
        return result;
    }

    public String getComment() {
        return "";
    }

    public abstract byte[] getValueField();

    public final ClassOfTag getClassOfTag() {
        byte msByte = this.insTagLengthField[0];
        return ClassOfTag.getInstance(msByte);
    }

    public long getNumberOfTag() {
        return BerTlv.numberOfTag(this.insTagLengthField);
    }

    public final String getBase64() {
        return BASE64_ENCODER.encodeToString(this.getEncoded());
    }

    public abstract byte[] getEncoded();

    ByteArrayOutputStream getEncoded(ByteArrayOutputStream out) {
        out.writeBytes(this.insTagLengthField);
        return out;
    }

    public static BerTlv getInstance(byte[] octets) {
        return BerTlv.getInstance(new ByteArrayInputStream(octets));
    }

    public static BerTlv getInstance(ByteBuffer buffer) {
        int position = buffer.position();
        try {
            return BerTlv.getFromBuffer(buffer);
        }
        catch (BufferUnderflowException e) {
            buffer.position(position);
            throw e;
        }
    }

    public static BerTlv getInstance(InputStream inputStream) {
        try {
            byte[] tagField = BerTlv.readTag(inputStream);
            return BerTlv.getFromInputStream(tagField, inputStream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unexpected IOException", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static BerTlv getInstance(long tag, byte[] valueField) {
        byte[] tagField = BerTlv.convertTag(tag);
        byte[] lengthField = Hex.toByteArray((CharSequence)(null == valueField ? "00" : BerTlv.getLengthField(valueField.length)));
        byte[][] list = new byte[][]{lengthField, valueField};
        try (PipedOutputStream po = new PipedOutputStream();){
            BerTlv berTlv;
            try (PipedInputStream pi = new PipedInputStream(po, 65536);){
                new Thread(() -> {
                    try {
                        for (byte[] octets : list) {
                            po.write(octets);
                            po.flush();
                        }
                    }
                    catch (IOException | NullPointerException exception) {
                        // empty catch block
                    }
                }).start();
                if (null == valueField) {
                    pi.close();
                }
                berTlv = BerTlv.getFromInputStream(tagField, pi);
            }
            return berTlv;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("UNEXPECTED", e);
        }
    }

    public static BerTlv getInstance(long tag, Collection<BerTlv> valueField) {
        byte[] tagField = BerTlv.convertTag(tag);
        if (0 == (tagField[0] & 0x20)) {
            int length = valueField.stream().map(tlv -> BigInteger.valueOf(tlv.getLengthOfTlvObject())).reduce(BigInteger::add).orElse(BigInteger.ZERO).intValueExact();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(length);
            for (BerTlv tlv2 : valueField) {
                tlv2.getEncoded(baos);
            }
            return BerTlv.getInstance(tag, baos.toByteArray());
        }
        return switch ((int)tag) {
            case 48 -> new DerSequence(valueField);
            case 49 -> new DerSet(valueField);
            default -> new ConstructedBerTlv(tag, valueField);
        };
    }

    public static BerTlv getInstance(long tag, String valueField) {
        return BerTlv.getInstance(tag, Hex.toByteArray((CharSequence)valueField));
    }

    public static BerTlv getInstance(String octets) {
        return BerTlv.getInstance(Hex.toByteArray((CharSequence)octets));
    }

    static BerTlv getFromBuffer(ByteBuffer buffer) {
        byte[] tagField = BerTlv.readTag(buffer);
        int tag = (int)BerTlv.convertTag(tagField);
        return switch (tag) {
            case 0 -> DerEndOfContent.readInstance(buffer);
            case 1 -> DerBoolean.readInstance(buffer);
            case 2 -> new DerInteger(buffer);
            case 3 -> new DerBitString(buffer);
            case 4 -> new DerOctetString(buffer);
            case 5 -> DerNull.readInstance(buffer);
            case 6 -> new DerOid(buffer);
            case 12 -> new DerUtf8String(buffer);
            case 48 -> new DerSequence(buffer);
            case 49 -> new DerSet(buffer);
            case 19 -> new DerPrintableString(buffer);
            case 20 -> new DerTeletexString(buffer);
            case 22 -> new DerIa5String(buffer);
            case 23 -> new DerUtcTime(buffer);
            case 7967 -> new DerDate(buffer);
            default -> 0 == (tagField[0] & 0x20) ? new PrimitiveBerTlv(tagField, buffer) : new ConstructedBerTlv(tagField, buffer);
        };
    }

    private static BerTlv getFromInputStream(byte[] tagField, InputStream inputStream) throws IOException {
        int tag = (int)BerTlv.convertTag(tagField);
        return switch (tag) {
            case 0 -> DerEndOfContent.readInstance(inputStream);
            case 1 -> DerBoolean.readInstance(inputStream);
            case 2 -> new DerInteger(inputStream);
            case 3 -> new DerBitString(inputStream);
            case 4 -> new DerOctetString(inputStream);
            case 5 -> DerNull.readInstance(inputStream);
            case 6 -> new DerOid(inputStream);
            case 12 -> new DerUtf8String(inputStream);
            case 48 -> new DerSequence(inputStream);
            case 49 -> new DerSet(inputStream);
            case 19 -> new DerPrintableString(inputStream);
            case 20 -> new DerTeletexString(inputStream);
            case 22 -> new DerIa5String(inputStream);
            case 23 -> new DerUtcTime(inputStream);
            case 7967 -> new DerDate(inputStream);
            default -> 0 == (tagField[0] & 0x20) ? new PrimitiveBerTlv(tagField, inputStream) : new ConstructedBerTlv(tagField, inputStream);
        };
    }

    public final String getLengthField() {
        return BerTlv.getLengthField(this.getLengthOfValueField());
    }

    static String getLengthField(long lengthOfValueField) {
        if (lengthOfValueField < 0L) {
            throw new IllegalArgumentException("length of value-field SHALL NOT be negative");
        }
        if (lengthOfValueField < 128L) {
            return String.format("%02x", lengthOfValueField);
        }
        int length = BerTlv.calculateLengthOfLengthField(lengthOfValueField) - 1;
        String formatter = String.format("8%d%%0%dx", length, length << 1);
        return String.format(formatter, lengthOfValueField);
    }

    public final int getLengthOfTagField() {
        return this.insLengthOfTagField;
    }

    public final long getLengthOfTlvObject() {
        return Math.addExact((long)this.insTagLengthField.length, this.getLengthOfValueField());
    }

    public final long getLengthOfValueField() {
        if (this.insLengthOfValueField < 0L) {
            throw new IllegalStateException("instance attribute LengthOfValueField not (yet) properly initialized");
        }
        return this.insLengthOfValueField;
    }

    public final long getTag() {
        return this.insTag;
    }

    public final String getTagField() {
        return Hex.toHexDigits((byte[])this.insTagLengthField, (int)0, (int)this.insLengthOfTagField);
    }

    static long[] readLength(ByteBuffer buffer) {
        int len = buffer.get() & 0xFF;
        if (len < 128) {
            return new long[]{len, 1L};
        }
        if (128 == len) {
            return new long[]{-1L, 1L};
        }
        byte[] length = new byte[len & 0x7F];
        buffer.get(length);
        return BerTlv.investigateLengthField(length);
    }

    static long[] readLength(InputStream inputStream) throws IOException {
        String message = "unexpected end of stream while reading a tag";
        int len = inputStream.read();
        if (len < 0) {
            throw new EOFException("unexpected end of stream while reading a tag");
        }
        if (len < 128) {
            return new long[]{len, 1L};
        }
        if (128 == len) {
            return new long[]{-1L, 1L};
        }
        byte[] length = new byte[len & 0x7F];
        int noRead = inputStream.readNBytes(length, 0, length.length);
        if (noRead < length.length) {
            throw new EOFException("unexpected end of stream while reading a tag");
        }
        return BerTlv.investigateLengthField(length);
    }

    private static long[] investigateLengthField(byte[] length) {
        BigInteger result = new BigInteger(1, length);
        if (result.bitLength() > 63) {
            throw new ArithmeticException("length of value-field too big for this implementation: '" + result.toString(16) + "'");
        }
        return new long[]{result.longValueExact(), 1 + length.length};
    }

    static byte[] readTag(ByteBuffer buffer) {
        byte octet = buffer.get();
        ArrayList<Byte> tag = new ArrayList<Byte>();
        tag.add(octet);
        if (31 == (octet & 0x1F)) {
            do {
                octet = buffer.get();
                tag.add(octet);
            } while ((octet & 0xFF) >= 128);
        }
        byte[] result = new byte[tag.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = (Byte)tag.get(i);
        }
        return result;
    }

    static byte[] readTag(InputStream inputStream) throws IOException {
        String message = "unexpected end of stream while reading a tag";
        int octet = inputStream.read();
        if (octet < 0) {
            throw new EOFException("unexpected end of stream while reading a tag");
        }
        ArrayList<Integer> tag = new ArrayList<Integer>();
        tag.add(octet);
        if (31 == (octet & 0x1F)) {
            do {
                if ((octet = inputStream.read()) < 0) {
                    throw new EOFException("unexpected end of stream while reading a tag");
                }
                tag.add(octet);
            } while (octet >= 128);
        }
        byte[] result = new byte[tag.size()];
        int index = 0;
        for (Integer element : tag) {
            result[index++] = element.byteValue();
        }
        return result;
    }

    final StringBuilder tagLength2String(String delimiter, String delo, int noI) {
        StringBuilder result = this.indentation(delo, noI);
        return result.append(this.getTagField()).append(delimiter).append(this.getLengthField());
    }

    StringBuilder indentation(String delo, int noI) {
        StringBuilder result;
        block3: {
            block2: {
                result = new StringBuilder();
                if (!"\n".equals(delo)) break block2;
                char numerator = (char)(102 + noI);
                int j = noI;
                while (j-- > 0) {
                    result.append(numerator).append("  ");
                }
                break block3;
            }
            if ("".equals(delo)) break block3;
            int j = noI;
            while (j-- > 0) {
                result.append(delo);
            }
        }
        return result;
    }

    public final String toString() {
        return Hex.toHexDigits((byte[])this.getEncoded());
    }

    public final String toString(String delimiter) {
        return this.toString(delimiter, "", 0, false);
    }

    abstract String toString(String var1, String var2, int var3, boolean var4);

    public final String toStringTree() {
        return this.toString(" ", "|  ", 0, true);
    }

    @Deprecated(forRemoval=true)
    protected final void finalize() {
    }
}

