/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.pcsc.lib;

import com.sun.jna.FunctionMapper;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import de.gematik.smartcards.pcsc.PcscException;
import de.gematik.smartcards.pcsc.constants.PcscStatus;
import de.gematik.smartcards.pcsc.lib.Dword;
import de.gematik.smartcards.pcsc.lib.DwordByReference;
import de.gematik.smartcards.pcsc.lib.ScardContext;
import de.gematik.smartcards.pcsc.lib.ScardContextByReference;
import de.gematik.smartcards.pcsc.lib.ScardHandle;
import de.gematik.smartcards.pcsc.lib.ScardHandleByReference;
import de.gematik.smartcards.pcsc.lib.ScardIoRequest;
import de.gematik.smartcards.pcsc.lib.ScardReaderState;
import de.gematik.smartcards.pcsc.lib.WinscardLibrary;
import de.gematik.smartcards.utils.AfiUtils;
import de.gematik.smartcards.utils.Hex;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WinscardLibraryImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(WinscardLibraryImpl.class);
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private final WinscardLibrary insLib;
    private final List<ScardIoRequest> insScardPciList;

    private WinscardLibraryImpl(WinscardLibrary lib, List<ScardIoRequest> scardPciList) {
        this.insLib = lib;
        this.insScardPciList = Collections.unmodifiableList(scardPciList);
    }

    public static WinscardLibraryImpl openLib() {
        Map<Object, Object> options;
        String libName;
        String windows = "WinSCard.dll";
        String mac = "/System/Library/Frameworks/PCSC.framework/PCSC";
        String pcsc = "libpcsclite.so.1";
        if (PcscStatus.OS_WINDOWS) {
            libName = "WinSCard.dll";
            options = Map.of("function-mapper", new WindowsFunctionMapper());
        } else if (PcscStatus.OS_MAC) {
            libName = "/System/Library/Frameworks/PCSC.framework/PCSC";
            options = Map.of("function-mapper", new MacFunctionMapper());
        } else {
            libName = "libpcsclite.so.1";
            options = Collections.emptyMap();
        }
        WinscardLibrary lib = (WinscardLibrary)Native.load((String)libName, WinscardLibrary.class, options);
        NativeLibrary nativeLibrary = NativeLibrary.getInstance((String)libName);
        List<ScardIoRequest> list = List.of(new ScardIoRequest(nativeLibrary.getGlobalVariableAddress("g_rgSCardT0Pci")), new ScardIoRequest(nativeLibrary.getGlobalVariableAddress("g_rgSCardT1Pci")), new ScardIoRequest(nativeLibrary.getGlobalVariableAddress("g_rgSCardRawPci")));
        list.forEach(pci -> {
            pci.read();
            pci.setAutoSynch(false);
        });
        return new WinscardLibraryImpl(lib, list);
    }

    private WinscardLibrary getLib() {
        return this.insLib;
    }

    public static List<String> multiString(byte[] multiString) {
        if (multiString.length > 0 && 0 == multiString[0]) {
            return Collections.emptyList();
        }
        try {
            String tmp = new String(multiString, StandardCharsets.UTF_8);
            return Arrays.asList(tmp.substring(0, tmp.indexOf("\u0000\u0000")).split("\u0000"));
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Multi-string must end with a null-terminated empty string.", e);
        }
    }

    public int scardEstablishContext(Dword dwScope, @Nullable Pointer pvReserved1, @Nullable Pointer pvReserved2, ScardContextByReference phContext) {
        LOGGER.atTrace().log("SCardEstablishContext(scope={}, pvReserved1={}, pvReserved2={}, phContext={})", new Object[]{dwScope, pvReserved1, pvReserved2, phContext});
        long startTime = System.nanoTime();
        Dword code = this.getLib().SCardEstablishContext(dwScope, pvReserved1, pvReserved2, phContext);
        long runTime = System.nanoTime() - startTime;
        long result = code.longValue();
        LOGGER.atTrace().log("status={}={} phContext={}, runTime={}", new Object[]{String.format("0x%x", result), PcscStatus.getExplanation((int)result), phContext, AfiUtils.nanoSeconds2Time((long)runTime)});
        return (int)result;
    }

    public int scardListReaders(@Nullable ScardContext context, @Nullable String mszGroups, @Nullable byte[] mszReaders, DwordByReference pcchReaders) {
        ByteBuffer bufReaders;
        String strReaders;
        String hexReaders;
        ByteBuffer bufGroups;
        String hexGroups;
        if (null == mszGroups) {
            hexGroups = "null";
            bufGroups = null;
        } else {
            byte[] octets = mszGroups.getBytes(UTF8);
            hexGroups = Hex.toHexDigits((byte[])octets);
            bufGroups = ByteBuffer.wrap(octets);
        }
        if (null == mszReaders) {
            hexReaders = null;
            strReaders = null;
            bufReaders = null;
        } else {
            hexReaders = Hex.toHexDigits((byte[])mszReaders);
            strReaders = WinscardLibraryImpl.multiString(mszReaders).toString();
            bufReaders = ByteBuffer.wrap(mszReaders);
        }
        LOGGER.atTrace().log("SCardListReaders(hContext={}, mszGroups='{}'={}, mszReaders='{}'={}, pcchReaders={})", new Object[]{context, hexGroups, mszGroups, hexReaders, strReaders, pcchReaders});
        long startTime = System.nanoTime();
        Dword code = this.getLib().SCardListReaders(context, bufGroups, bufReaders, pcchReaders);
        long runTime = System.nanoTime() - startTime;
        long result = code.longValue();
        if (null != mszReaders) {
            hexReaders = Hex.toHexDigits((byte[])mszReaders);
            strReaders = WinscardLibraryImpl.multiString(mszReaders).toString();
        }
        LOGGER.atTrace().log("status={}={} mszReaders='{}'={}, pccsReaders={}, runTime={}", new Object[]{String.format("0x%x", result), PcscStatus.getExplanation((int)result), hexReaders, strReaders, pcchReaders, AfiUtils.nanoSeconds2Time((long)runTime)});
        return (int)result;
    }

    public int scardGetStatusChange(ScardContext context, long dwTimeout, ScardReaderState ... rgReaderStates) {
        int cReaders = rgReaderStates.length;
        LOGGER.atTrace().log("SCardGetStatusChange(hContext={}, dwTimeout={}, cReaders={}, rgReaderStates={})", new Object[]{context, dwTimeout, cReaders, ScardReaderState.toString(rgReaderStates)});
        long startTime = System.nanoTime();
        Dword code = this.getLib().SCardGetStatusChange(context, new Dword(dwTimeout), rgReaderStates, new Dword(cReaders));
        long runTime = System.nanoTime() - startTime;
        long result = code.longValue();
        LOGGER.atTrace().log("status={}={} rgReaderStates={}, runTime={}", new Object[]{String.format("0x%x", result), PcscStatus.getExplanation((int)result), ScardReaderState.toString(rgReaderStates), AfiUtils.nanoSeconds2Time((long)runTime)});
        return (int)result;
    }

    public int scardConnect(ScardContext context, String szReader, int dwShareMode, int dwPreferredProtocols, ScardHandleByReference phCard, DwordByReference pdwActiveProtocol) {
        LOGGER.atTrace().log("SCardConnect(hContext={}, szReader={}, dwSharedMode={}, dwPreferredProtocols={}, phCard={}, pdwActiveProtocol={})", new Object[]{context, szReader, dwShareMode, dwPreferredProtocols, phCard, pdwActiveProtocol});
        long startTime = System.nanoTime();
        Dword code = this.getLib().SCardConnect(context, szReader, new Dword(dwShareMode), new Dword(dwPreferredProtocols), phCard, pdwActiveProtocol);
        long runTime = System.nanoTime() - startTime;
        long result = code.longValue();
        LOGGER.atTrace().log("status={}={} phCard={}, pdwActiveProtocol={}, runTime={}", new Object[]{String.format("0x%x", result), PcscStatus.getExplanation((int)result), phCard, pdwActiveProtocol, AfiUtils.nanoSeconds2Time((long)runTime)});
        return (int)result;
    }

    public int scardStatus(ScardHandle card, @Nullable ByteBuffer mszReaderName, DwordByReference pcchReaderLen, DwordByReference pdwState, DwordByReference pdwProtocol, ByteBuffer pbAtr, DwordByReference pcbAtrLen) {
        LOGGER.atTrace().log("SCardStatus(hCard={}, mszReaderName={}, pcchReaderLen={}, pdwState={}, pdwProtocol={}, pbAtr={}, pcbAtrlen={})", new Object[]{card, mszReaderName, pcchReaderLen, pdwState, pdwProtocol, Hex.toHexDigits((byte[])pbAtr.array()), pcbAtrLen});
        long startTime = System.nanoTime();
        Dword code = this.getLib().SCardStatus(card, mszReaderName, pcchReaderLen, pdwState, pdwProtocol, pbAtr, pcbAtrLen);
        long runTime = System.nanoTime() - startTime;
        long result = code.longValue();
        LOGGER.atTrace().log("status={}={} mszReaderName={}, pcchReaderLen={}, pdwState={}, pdwProtocol={}, pbAtr={}, pcbAtrlen={}, runTime={}", new Object[]{String.format("0x%x", result), PcscStatus.getExplanation((int)result), mszReaderName, pcchReaderLen, pdwState, pdwProtocol, Hex.toHexDigits((byte[])pbAtr.array()), pcbAtrLen, AfiUtils.nanoSeconds2Time((long)runTime)});
        return (int)result;
    }

    @VisibleForTesting
    int scardTransmit(ScardHandle card, ScardIoRequest pioSendPci, byte[] sendBuffer, @Nullable ScardIoRequest pioRecvPci, ByteBuffer pbRecvBuffer, DwordByReference pcbRecvLength, double ... executionTime) {
        LOGGER.atTrace().log("SCardTransmit(hCard={}, pioSendPci={}, pbSendBuffer={}, pioRecvPci={}, pbRecvbuffer='...', pcbRecvLength={})", new Object[]{card, pioSendPci, Hex.toHexDigits((byte[])sendBuffer), pioRecvPci, pcbRecvLength});
        long startTime = System.nanoTime();
        Dword code = this.getLib().SCardTransmit(card, pioSendPci, ByteBuffer.wrap(sendBuffer), new Dword(sendBuffer.length), pioRecvPci, pbRecvBuffer, pcbRecvLength);
        long runTime = System.nanoTime() - startTime;
        executionTime[0] = (double)runTime * 1.0E-9;
        long result = code.longValue();
        LOGGER.atTrace().log("status={}={} pioRecvPci={}, pbRecvBuffer={}, pcbRecvLength={}, runTime={}", new Object[]{String.format("0x%x", result), PcscStatus.getExplanation((int)result), pioRecvPci, Hex.toHexDigits((byte[])pbRecvBuffer.array(), (int)0, (int)pcbRecvLength.getValue().intValue()), pcbRecvLength, AfiUtils.nanoSeconds2Time((long)runTime)});
        return (int)result;
    }

    public byte[] scardTransmit(ScardHandle card, byte[] sendBuffer, double ... executionTime) throws PcscException {
        ScardIoRequest pioSendPci = new ScardIoRequest(2L);
        byte[] rsp = new byte[65538];
        ByteBuffer pbRecvBuffer = ByteBuffer.wrap(rsp);
        DwordByReference pcbRecvLength = new DwordByReference(new Dword(rsp.length));
        PcscStatus.check("scardTransmit", this.scardTransmit(card, pioSendPci, sendBuffer, null, pbRecvBuffer, pcbRecvLength, executionTime));
        return Arrays.copyOfRange(rsp, 0, pcbRecvLength.getValue().intValue());
    }

    public int scardDisconnect(ScardHandle card, int dwPosition) {
        LOGGER.atTrace().log("SCardDisconnect(hCard={}, dwPosition={})", (Object)card, (Object)dwPosition);
        long startTime = System.nanoTime();
        Dword code = this.getLib().SCardDisconnect(card, new Dword(dwPosition));
        long runTime = System.nanoTime() - startTime;
        long result = code.longValue();
        LOGGER.atTrace().log("status={}={} runTime={}", new Object[]{String.format("0x%x", result), PcscStatus.getExplanation((int)result), AfiUtils.nanoSeconds2Time((long)runTime)});
        return (int)result;
    }

    public int scardReleaseContext(ScardContext context) {
        LOGGER.atTrace().log("SCardReleaseContext(hContext={}", (Object)context);
        long startTime = System.nanoTime();
        Dword code = this.getLib().SCardReleaseContext(context);
        long runTime = System.nanoTime() - startTime;
        long result = code.longValue();
        LOGGER.atTrace().log("status={}={} runTime={}", new Object[]{String.format("0x%x", result), PcscStatus.getExplanation((int)result), AfiUtils.nanoSeconds2Time((long)runTime)});
        return (int)result;
    }

    @VisibleForTesting
    List<ScardIoRequest> getScardPciList() {
        return this.insScardPciList;
    }

    private static final class WindowsFunctionMapper
    implements FunctionMapper {
        private static final Set<String> ASCII_SUFFIX_NAMES = Set.of("SCardListReaderGroups", "SCardListReaders", "SCardGetStatusChange", "SCardConnect", "SCardStatus");

        private WindowsFunctionMapper() {
        }

        public String getFunctionName(NativeLibrary library, Method method) {
            Object name = method.getName();
            if (ASCII_SUFFIX_NAMES.contains(name)) {
                name = (String)name + "A";
            }
            return name;
        }
    }

    private static final class MacFunctionMapper
    implements FunctionMapper {
        private MacFunctionMapper() {
        }

        public String getFunctionName(NativeLibrary library, Method method) {
            String name = method.getName();
            if ("SCardControl".equals(name)) {
                name = "SCardControl132";
            }
            return name;
        }
    }
}

