/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.pcsc.lib;

import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import de.gematik.smartcards.pcsc.lib.Dword;
import de.gematik.smartcards.utils.AfiUtils;
import de.gematik.smartcards.utils.Hex;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.VisibleForTesting;

@Structure.FieldOrder(value={"szReader", "pvUserData", "dwCurrentState", "dwEventState", "cbAtr", "rgbAtr"})
@SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE", "UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"})
public final class ScardReaderState
extends Structure {
    private static final int ALIGN = Platform.isMac() ? 1 : 0;
    static final String SUFFIX = ", pvUserData=%s, cS=0x%04x-%04x=%d-%s, eS=0x%04x-%04x=%d-%s, atrSize=%2d, ATR='%s'";
    @Nullable
    public String szReader;
    @Nullable
    public Pointer pvUserData;
    public Dword dwCurrentState;
    public Dword dwEventState;
    public Dword cbAtr;
    public byte[] rgbAtr;

    public ScardReaderState() {
        super(null, ALIGN);
        this.dwEventState = this.dwCurrentState = new Dword();
        this.cbAtr = this.dwCurrentState;
        this.rgbAtr = new byte[33];
    }

    public static ScardReaderState[] createArray(List<String> readerNames, boolean withPnp) {
        Structure[] result = new ScardReaderState[(withPnp ? 1 : 0) + readerNames.size()];
        new ScardReaderState().toArray(result);
        int i = 0;
        if (withPnp) {
            result[i++].szReader = "\\\\?PnP?\\Notification";
        }
        for (String name : readerNames) {
            result[i++].szReader = name;
        }
        return result;
    }

    public String toString() {
        return this.toString("szReader=%s, pvUserData=%s, cS=0x%04x-%04x=%d-%s, eS=0x%04x-%04x=%d-%s, atrSize=%2d, ATR='%s'");
    }

    @VisibleForTesting
    String toString(String formatter) {
        long currentState = this.dwCurrentState.longValue();
        int csCounter = (int)(currentState >> 16);
        int csState = (int)(currentState & 0xFFFFL);
        long eventState = this.dwEventState.longValue();
        int esCounter = (int)(eventState >> 16);
        int esState = (int)(eventState & 0xFFFFL);
        return String.format(formatter, this.szReader, this.pvUserData, csCounter, csState, csCounter, ScardReaderState.toString(csState), esCounter, esState, esCounter, ScardReaderState.toString(esState), this.cbAtr.longValue(), Hex.toHexDigits((byte[])this.rgbAtr));
    }

    public static String toString(ScardReaderState ... readerStates) {
        int maxLengthName = Arrays.stream(readerStates).mapToInt(state -> null == state.szReader ? 0 : state.szReader.length()).max().orElse(0);
        String formatter = "szReader=%-" + maxLengthName + "s, pvUserData=%s, cS=0x%04x-%04x=%d-%s, eS=0x%04x-%04x=%d-%s, atrSize=%2d, ATR='%s'";
        AtomicInteger counter = new AtomicInteger();
        return String.format("[%n%s%n]", Arrays.stream(readerStates).map(state -> String.format("%3d.: %s", counter.incrementAndGet(), state.toString(formatter))).collect(Collectors.joining(AfiUtils.LINE_SEPARATOR)));
    }

    @VisibleForTesting
    static List<String> toString(int state) {
        if (0 == (state & Short.MAX_VALUE)) {
            return Collections.emptyList();
        }
        return Stream.of(Map.entry(1, "ignore"), Map.entry(2, "changed"), Map.entry(4, "unknown"), Map.entry(8, "unavailable"), Map.entry(16, "empty"), Map.entry(32, "present"), Map.entry(64, "atrmatch"), Map.entry(128, "exclusive"), Map.entry(256, "inuse"), Map.entry(512, "mute"), Map.entry(1024, "unpowered")).filter(entry -> 0 != (state & (Integer)entry.getKey())).map(Map.Entry::getValue).toList();
    }
}

