/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.pcsc.constants;

import com.sun.jna.Platform;
import de.gematik.smartcards.pcsc.PcscException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.VisibleForTesting;

public final class PcscStatus {
    public static final boolean OS_WINDOWS = Platform.isWindows();
    public static final boolean OS_LINUX = Platform.isLinux();
    public static final boolean OS_MAC = Platform.isMac();
    public static final int SCARD_S_SUCCESS = 0;
    public static final int SCARD_F_INTERNAL_ERROR = -2146435071;
    public static final int SCARD_E_CANCELLED = -2146435070;
    public static final int SCARD_E_INVALID_HANDLE = -2146435069;
    public static final int SCARD_E_INVALID_PARAMETER = -2146435068;
    public static final int SCARD_E_INVALID_TARGET = -2146435067;
    public static final int SCARD_E_NO_MEMORY = -2146435066;
    public static final int SCARD_F_WAITED_TOO_LONG = -2146435065;
    public static final int SCARD_E_INSUFFICIENT_BUFFER = -2146435064;
    public static final int SCARD_E_UNKNOWN_READER = -2146435063;
    public static final int SCARD_E_TIMEOUT = -2146435062;
    public static final int SCARD_E_SHARING_VIOLATION = -2146435061;
    public static final int SCARD_E_NO_SMARTCARD = -2146435060;
    public static final int SCARD_E_UNKNOWN_CARD = -2146435059;
    public static final int SCARD_E_CANT_DISPOSE = -2146435058;
    public static final int SCARD_E_PROTO_MISMATCH = -2146435057;
    public static final int SCARD_E_NOT_READY = -2146435056;
    public static final int SCARD_E_INVALID_VALUE = -2146435055;
    public static final int SCARD_E_SYSTEM_CANCELLED = -2146435054;
    public static final int SCARD_F_COMM_ERROR = -2146435053;
    public static final int SCARD_F_UNKNOWN_ERROR = -2146435052;
    public static final int SCARD_E_INVALID_ATR = -2146435051;
    public static final int SCARD_E_NOT_TRANSACTED = -2146435050;
    public static final int SCARD_E_READER_UNAVAILABLE = -2146435049;
    public static final int SCARD_P_SHUTDOWN = -2146435048;
    public static final int SCARD_E_PCI_TOO_SMALL = -2146435047;
    public static final int SCARD_E_READER_UNSUPPORTED = -2146435046;
    public static final int SCARD_E_DUPLICATE_READER = -2146435045;
    public static final int SCARD_E_CARD_UNSUPPORTED = -2146435044;
    public static final int SCARD_E_NO_SERVICE = -2146435043;
    public static final int SCARD_E_SERVICE_STOPPED = -2146435042;
    public static final int SCARD_E_UNEXPECTED = OS_WINDOWS ? -2146435041 : 0;
    public static final int SCARD_E_UNSUPPORTED_FEATURE = OS_WINDOWS ? -2146435038 : -2146435041;
    public static final int SCARD_E_ICC_INSTALLATION = -2146435040;
    public static final int SCARD_E_ICC_CREATEORDER = -2146435039;
    public static final int SCARD_E_DIR_NOT_FOUND = -2146435037;
    public static final int SCARD_E_FILE_NOT_FOUND = -2146435036;
    public static final int SCARD_E_NO_DIR = -2146435035;
    public static final int SCARD_E_NO_FILE = -2146435034;
    public static final int SCARD_E_NO_ACCESS = -2146435033;
    public static final int SCARD_E_WRITE_TOO_MANY = -2146435032;
    public static final int SCARD_E_BAD_SEEK = -2146435031;
    public static final int SCARD_E_INVALID_CHV = -2146435030;
    public static final int SCARD_E_UNKNOWN_RES_MNG = -2146435029;
    public static final int SCARD_E_NO_SUCH_CERTIFICATE = -2146435028;
    public static final int SCARD_E_CERTIFICATE_UNAVAILABLE = -2146435027;
    public static final int SCARD_E_NO_READERS_AVAILABLE = -2146435026;
    public static final int SCARD_E_COMM_DATA_LOST = -2146435025;
    public static final int SCARD_E_NO_KEY_CONTAINER = -2146435024;
    public static final int SCARD_E_SERVER_TOO_BUSY = -2146435023;
    public static final int SCARD_W_UNSUPPORTED_CARD = -2146434971;
    public static final int SCARD_W_UNRESPONSIVE_CARD = -2146434970;
    public static final int SCARD_W_UNPOWERED_CARD = -2146434969;
    public static final int SCARD_W_RESET_CARD = -2146434968;
    public static final int SCARD_W_REMOVED_CARD = -2146434967;
    public static final int SCARD_W_SECURITY_VIOLATION = -2146434966;
    public static final int SCARD_W_WRONG_CHV = -2146434965;
    public static final int SCARD_W_CHV_BLOCKED = -2146434964;
    public static final int SCARD_W_EOF = -2146434963;
    public static final int SCARD_W_CANCELLED_BY_USER = -2146434962;
    public static final int SCARD_W_CARD_NOT_AUTHENTICATED = -2146434961;
    public static final int ERROR_INVALID_HANDLE = 6;
    public static final int ERROR_BAD_COMMAND = 22;
    private static final List<Map.Entry<Integer, List<String>>> MAPPING = List.of(Map.entry(0, List.of("SCARD_S_SUCCESS", "No error was encountered.")), Map.entry(-2146435071, List.of("SCARD_F_INTERNAL_ERROR", "An internal consistency check failed.")), Map.entry(-2146435070, List.of("SCARD_E_CANCELLED", "The action was cancelled by an SCardCancel request.")), Map.entry(-2146435069, List.of("SCARD_E_INVALID_HANDLE", "The supplied handle was invalid.")), Map.entry(-2146435068, List.of("SCARD_E_INVALID_PARAMETER", "One or more of the supplied parameters could not be properly interpreted.")), Map.entry(-2146435067, List.of("SCARD_E_INVALID_TARGET", "Registry startup information is missing or invalid.")), Map.entry(-2146435066, List.of("SCARD_E_NO_MEMORY", "Not enough memory available to complete this command.")), Map.entry(-2146435065, List.of("SCARD_F_WAITED_TOO_LONG", "An internal consistency timer has expired.")), Map.entry(-2146435064, List.of("SCARD_E_INSUFFICIENT_BUFFER", "The data buffer to receive returned data is too small for the returned data.")), Map.entry(-2146435063, List.of("SCARD_E_UNKNOWN_READER", "The specified reader name is not recognized.")), Map.entry(-2146435062, List.of("SCARD_E_TIMEOUT", "The user-specified timeout value has expired.")), Map.entry(-2146435061, List.of("SCARD_E_SHARING_VIOLATION", "The smart card cannot be accessed because of other connections outstanding.")), Map.entry(-2146435060, List.of("SCARD_E_NO_SMARTCARD", "The operation requires a Smart Card, but no Smart Card is currently in the device.")), Map.entry(-2146435059, List.of("SCARD_E_UNKNOWN_CARD", "The specified smart card name is not recognized.")), Map.entry(-2146435058, List.of("SCARD_E_CANT_DISPOSE", "The system could not dispose of the media in the requested manner.")), Map.entry(-2146435057, List.of("SCARD_E_PROTO_MISMATCH", "The requested protocols are incompatible with the protocol currently in use with the smart card.")), Map.entry(-2146435056, List.of("SCARD_E_NOT_READY", "The reader or smart card is not ready to accept commands.")), Map.entry(-2146435055, List.of("SCARD_E_INVALID_VALUE", "One or more of the supplied parameters values could not be properly interpreted.")), Map.entry(-2146435054, List.of("SCARD_E_SYSTEM_CANCELLED", "The action was cancelled by the system, presumably to log off or shut down.")), Map.entry(-2146435053, List.of("SCARD_F_COMM_ERROR", "An internal communications error has been detected.")), Map.entry(-2146435052, List.of("SCARD_F_UNKNOWN_ERROR", "An internal error has been detected, but the source is unknown.")), Map.entry(-2146435051, List.of("SCARD_E_INVALID_ATR", "An ATR obtained from the registry is not a valid ATR string.")), Map.entry(-2146435050, List.of("SCARD_E_NOT_TRANSACTED", "An attempt was made to end a non-existent transaction.")), Map.entry(-2146435049, List.of("SCARD_E_READER_UNAVAILABLE", "The specified reader is not currently available for use.")), Map.entry(-2146435048, List.of("SCARD_P_SHUTDOWN", "The operation has been aborted to allow the server application to exit.")), Map.entry(-2146435047, List.of("SCARD_E_PCI_TOO_SMALL", "The PCI Receive buffer was too small.")), Map.entry(-2146435046, List.of("SCARD_E_READER_UNSUPPORTED", "The reader driver does not meet minimal requirements for support.")), Map.entry(-2146435045, List.of("SCARD_E_DUPLICATE_READER", "The reader driver did not produce a unique reader name.")), Map.entry(-2146435044, List.of("SCARD_E_CARD_UNSUPPORTED", "The smart card does not meet minimal requirements for support.")), Map.entry(-2146435043, List.of("SCARD_E_NO_SERVICE", "The Smart card resource manager is not running.")), Map.entry(-2146435042, List.of("SCARD_E_SERVICE_STOPPED", "The Smart card resource manager has shut down.")), Map.entry(SCARD_E_UNEXPECTED, List.of("SCARD_E_UNEXPECTED", "An unexpected card error has occurred.")), Map.entry(SCARD_E_UNSUPPORTED_FEATURE, List.of("SCARD_E_UNSUPPORTED_FEATURE", "This smart card does not support the requested feature.")), Map.entry(-2146435040, List.of("SCARD_E_ICC_INSTALLATION", "No primary provider can be found for the smart card.")), Map.entry(-2146435039, List.of("SCARD_E_ICC_CREATEORDER", "The requested order of object creation is not supported.")), Map.entry(-2146435037, List.of("SCARD_E_DIR_NOT_FOUND", "The identified directory does not exist in the smart card.")), Map.entry(-2146435036, List.of("SCARD_E_FILE_NOT_FOUND", "The identified file does not exist in the smart card.")), Map.entry(-2146435035, List.of("SCARD_E_NO_DIR", "The supplied path does not represent a smart card directory.")), Map.entry(-2146435034, List.of("SCARD_E_NO_FILE", "The supplied path does not represent a smart card file.")), Map.entry(-2146435033, List.of("SCARD_E_NO_ACCESS", "Access is denied to this file.")), Map.entry(-2146435032, List.of("SCARD_E_WRITE_TOO_MANY", "The smart card does not have enough memory to store the information.")), Map.entry(-2146435031, List.of("SCARD_E_BAD_SEEK", "There was an error trying to set the smart card file object pointer.")), Map.entry(-2146435030, List.of("SCARD_E_INVALID_CHV", "The supplied PIN is incorrect.")), Map.entry(-2146435029, List.of("SCARD_E_UNKNOWN_RES_MNG", "An unrecognized error code was returned from a layered component.")), Map.entry(-2146435028, List.of("SCARD_E_NO_SUCH_CERTIFICATE", "The requested certificate does not exist.")), Map.entry(-2146435027, List.of("SCARD_E_CERTIFICATE_UNAVAILABLE", "The requested certificate could not be obtained.")), Map.entry(-2146435026, List.of("SCARD_E_NO_READERS_AVAILABLE", "Cannot find a smart card reader.")), Map.entry(-2146435025, List.of("SCARD_E_COMM_DATA_LOST", "A communications error with the smart card has been detected. Retry the operation.")), Map.entry(-2146435024, List.of("SCARD_E_NO_KEY_CONTAINER", "The requested key container does not exist on the smart card.")), Map.entry(-2146435023, List.of("SCARD_E_SERVER_TOO_BUSY", "The Smart Card Resource Manager is too busy to complete this operation.")), Map.entry(-2146434971, List.of("SCARD_W_UNSUPPORTED_CARD", "The reader cannot communicate with the card, due to ATR string configuration conflicts.")), Map.entry(-2146434970, List.of("SCARD_W_UNRESPONSIVE_CARD", "The smart card is not responding to a reset.")), Map.entry(-2146434969, List.of("SCARD_W_UNPOWERED_CARD", "Power has been removed from the smart card, so that further communication is not possible.")), Map.entry(-2146434968, List.of("SCARD_W_RESET_CARD", "The smart card has been reset, so any shared state information is invalid.")), Map.entry(-2146434967, List.of("SCARD_W_REMOVED_CARD", "The smart card has been removed, so further communication is not possible.")), Map.entry(-2146434966, List.of("SCARD_W_SECURITY_VIOLATION", "Access was denied because of a security violation.")), Map.entry(-2146434965, List.of("SCARD_W_WRONG_CHV", "The card cannot be accessed because the wrong PIN was presented.")), Map.entry(-2146434964, List.of("SCARD_W_CHV_BLOCKED", "The card cannot be accessed because the maximum number of PIN entry attempts has been reached.")), Map.entry(-2146434963, List.of("SCARD_W_EOF", "The end of the smart card file has been reached.")), Map.entry(-2146434962, List.of("SCARD_W_CANCELLED_BY_USER", "The user pressed \"Cancel\" on a Smart Card Selection Dialog.")), Map.entry(-2146434961, List.of("SCARD_W_CARD_NOT_AUTHENTICATED", "No PIN was presented to the smart card.")), Map.entry(6, List.of("ERROR_INVALID_HANDLE", "The handle is invalid.")), Map.entry(22, List.of("ERROR_BAD_COMMAND", "The device does not recognize the command.")));
    @VisibleForTesting
    static final Map<Integer, String> NAME = PcscStatus.getMappingName();
    @VisibleForTesting
    static final Map<Integer, String> DESCRIPTION = PcscStatus.getMappingDescription();

    private PcscStatus() {
    }

    private static Map<Integer, String> getMappingName() {
        ConcurrentHashMap result = new ConcurrentHashMap();
        MAPPING.forEach(entry -> {
            int code = (Integer)entry.getKey();
            if (!result.containsKey(code)) {
                result.put(code, (String)((List)entry.getValue()).getFirst());
            }
        });
        return Collections.unmodifiableMap(result);
    }

    private static Map<Integer, String> getMappingDescription() {
        ConcurrentHashMap result = new ConcurrentHashMap();
        MAPPING.forEach(entry -> {
            int code = (Integer)entry.getKey();
            if (!result.containsKey(code)) {
                result.put(code, (String)((List)entry.getValue()).get(1));
            }
        });
        return Collections.unmodifiableMap(result);
    }

    public static void check(String message, int code) throws PcscException {
        if (0 != code) {
            throw new PcscException(code, message + ": " + PcscStatus.getExplanation(code));
        }
    }

    public static String getExplanation(int code) {
        String name = NAME.get(code);
        String description = DESCRIPTION.get(code);
        if (null == name) {
            return String.format("no explanation for code = 0x%x = %d", code, code);
        }
        return name + " -> " + description;
    }
}

