/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.pcsc;

import de.gematik.smartcards.pcsc.EstablishContextException;
import de.gematik.smartcards.pcsc.Ifd;
import de.gematik.smartcards.pcsc.PcscException;
import de.gematik.smartcards.pcsc.constants.PcscStatus;
import de.gematik.smartcards.pcsc.lib.Dword;
import de.gematik.smartcards.pcsc.lib.DwordByReference;
import de.gematik.smartcards.pcsc.lib.ScardContext;
import de.gematik.smartcards.pcsc.lib.ScardContextByReference;
import de.gematik.smartcards.pcsc.lib.ScardHandleByReference;
import de.gematik.smartcards.pcsc.lib.ScardReaderState;
import de.gematik.smartcards.pcsc.lib.WinscardLibraryImpl;
import de.gematik.smartcards.utils.AfiUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IfdCollection
extends CardTerminals
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IfdCollection.class);
    private final Map<String, Ifd> insIfdCollection = new ConcurrentHashMap<String, Ifd>();
    private boolean insIsClosed;
    private final WinscardLibraryImpl insLibrary;
    private final ScardContext insScardContext;

    public IfdCollection() {
        this(2);
    }

    @VisibleForTesting
    IfdCollection(int scope) {
        try {
            LOGGER.atDebug().log("IfdCollection constructed: {}", (Object)LOGGER.getName());
            WinscardLibraryImpl library = WinscardLibraryImpl.openLib();
            ScardContextByReference phContext = new ScardContextByReference();
            int code = library.scardEstablishContext(new Dword(scope), null, null, phContext);
            PcscStatus.check("SCardEstablishContext", code);
            this.insLibrary = library;
            this.insScardContext = phContext.getValue();
        }
        catch (PcscException e) {
            LOGGER.atError().log("SCardEstablishContext failed", (Object)e);
            throw new EstablishContextException(e);
        }
    }

    @Override
    public List<CardTerminal> list(CardTerminals.State state) throws CardException {
        LOGGER.atDebug().log("list({})", (Object)state);
        List<String> readerNames = switch (state) {
            case CardTerminals.State.ALL, CardTerminals.State.CARD_PRESENT, CardTerminals.State.CARD_ABSENT -> {
                List<String> allReaders = this.scardListReaders();
                List<String> recentlyRemoved = this.insIfdCollection.keySet().stream().filter(name -> !allReaders.contains(name)).toList();
                recentlyRemoved.forEach(this.insIfdCollection::remove);
                if (CardTerminals.State.ALL.equals((Object)state)) {
                    yield allReaders;
                }
                int wantedState = CardTerminals.State.CARD_PRESENT.equals((Object)state) ? 32 : 16;
                ScardReaderState[] rgReaderStates = ScardReaderState.createArray(allReaders, false);
                PcscStatus.check("IfdCollection.list(" + String.valueOf((Object)state) + ")", this.getLibrary().scardGetStatusChange(this.getScardContext(), 0L, rgReaderStates));
                yield Arrays.stream(rgReaderStates).filter(readerState -> 0 != (readerState.dwEventState.intValue() & wantedState)).map(readerState -> String.format("%s", readerState.szReader)).toList();
            }
            default -> throw new IllegalArgumentException("state = " + String.valueOf((Object)state) + " not (yet) supported by this implementation");
        };
        LOGGER.atDebug().log("readerNames = {}", readerNames);
        return readerNames.stream().map(n -> this.insIfdCollection.computeIfAbsent((String)n, i -> new Ifd(this, (String)n))).map(n -> n).toList();
    }

    @Override
    public boolean waitForChange(long timeout) throws CardException {
        throw new PcscException(0, "not (yet) implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws PcscException {
        IfdCollection ifdCollection = this;
        synchronized (ifdCollection) {
            if (this.isClosed()) {
                LOGGER.atDebug().log("IfdCollection already closed");
                return;
            }
            LOGGER.atDebug().log("IfdCollection closing");
            this.insIsClosed = true;
        }
        PcscStatus.check("SCardReleaseContext", this.getLibrary().scardReleaseContext(this.getScardContext()));
    }

    public boolean isClosed() {
        return this.insIsClosed;
    }

    WinscardLibraryImpl getLibrary() {
        return this.insLibrary;
    }

    @VisibleForTesting
    ScardContext getScardContext() {
        return this.insScardContext;
    }

    @VisibleForTesting
    List<String> scardListReaders() throws PcscException {
        int status;
        String mszReaderGroups = "SCard$AllReaders\u0000\u0000";
        DwordByReference pcchReaders = new DwordByReference();
        byte[] mszReaders = AfiUtils.EMPTY_OS;
        do {
            if (0 != (status = this.getLibrary().scardListReaders(this.getScardContext(), "SCard$AllReaders\u0000\u0000", null, pcchReaders))) continue;
            mszReaders = new byte[pcchReaders.getValue().intValue()];
            status = this.getLibrary().scardListReaders(this.getScardContext(), "SCard$AllReaders\u0000\u0000", mszReaders, pcchReaders);
        } while (-2146435064 == status);
        return switch (status) {
            case 0 -> WinscardLibraryImpl.multiString(mszReaders);
            case -2146435049, -2146435026 -> Collections.emptyList();
            default -> {
                PcscStatus.check("SCardListReaders", status);
                throw new IllegalStateException("Reached line of code which SHALL be unreachable. Something is wrong with the PcscStatus.check(...)-method");
            }
        };
    }

    int scardGetStatusChange(long dwTimeout, ScardReaderState ... rgReaderStates) {
        return this.getLibrary().scardGetStatusChange(this.getScardContext(), dwTimeout, rgReaderStates);
    }

    int scardConnect(String szReader, int dwShareMode, int dwPreferredProtocols, ScardHandleByReference phCard, DwordByReference pdwActiveProtocol) {
        return this.getLibrary().scardConnect(this.getScardContext(), szReader, dwShareMode, dwPreferredProtocols, phCard, pdwActiveProtocol);
    }
}

