/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.pcsc;

import de.gematik.smartcards.pcsc.Icc;
import de.gematik.smartcards.pcsc.IfdCollection;
import de.gematik.smartcards.pcsc.PcscException;
import de.gematik.smartcards.pcsc.constants.PcscStatus;
import de.gematik.smartcards.pcsc.lib.Dword;
import de.gematik.smartcards.pcsc.lib.ScardReaderState;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardNotPresentException;
import javax.smartcardio.CardTerminal;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public final class Ifd
extends CardTerminal {
    @Nullable
    private Icc insIcc;
    private final IfdCollection insIfdCollection;
    private final String insName;

    Ifd(IfdCollection ifdCollection, String name) {
        this.insIfdCollection = ifdCollection;
        this.insName = name;
    }

    IfdCollection getIfdCollection() {
        return this.insIfdCollection;
    }

    @Override
    public String getName() {
        return this.insName;
    }

    @Override
    public synchronized Card connect(String protocol) throws CardException {
        if (null != this.insIcc) {
            if (this.insIcc.isValid()) {
                String iccProtocol = this.insIcc.getProtocol();
                if (protocol.equals(iccProtocol) || "*".equals(protocol)) {
                    return this.insIcc;
                }
                throw new CardException("Cannot connect using " + protocol + ", connection already established using " + iccProtocol);
            }
            this.insIcc = null;
        }
        try {
            this.insIcc = new Icc(this, protocol);
            return this.insIcc;
        }
        catch (PcscException e) {
            switch (e.getCode()) {
                case -2146435060: 
                case -2146434967: {
                    throw new CardNotPresentException("No card present", e);
                }
            }
            throw new CardException("connect() failed", e);
        }
    }

    @Override
    public boolean isCardPresent() throws CardException {
        ScardReaderState[] rgReaderStates = ScardReaderState.createArray(List.of(this.getName()), false);
        PcscStatus.check("Ifd.isCardPresent()", this.getIfdCollection().scardGetStatusChange(0L, rgReaderStates));
        int state = rgReaderStates[0].dwEventState.intValue();
        return 32 == (state & 0x20);
    }

    public String toString() {
        return "PC/SC IFD " + this.getName();
    }

    @Override
    public boolean waitForCardPresent(long timeout) throws CardException {
        return this.waitForCard(true, timeout);
    }

    @Override
    public boolean waitForCardAbsent(long timeout) throws CardException {
        return this.waitForCard(false, timeout);
    }

    private boolean waitForCard(boolean isPresent, long timeout) throws CardException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must not be negative");
        }
        long startTime = System.currentTimeMillis();
        ScardReaderState[] rgReaderStates = ScardReaderState.createArray(List.of(this.getName()), false);
        ScardReaderState ifd = rgReaderStates[0];
        int wantedState = isPresent ? 32 : 16;
        try {
            PcscStatus.check("ScardGetStatusChange.1", this.getIfdCollection().scardGetStatusChange(0L, ifd));
            while (true) {
                int state;
                if (wantedState == ((state = ifd.dwEventState.intValue()) & wantedState)) {
                    return true;
                }
                ifd.dwCurrentState = ifd.dwEventState;
                ifd.dwEventState = new Dword();
                long remaining = 0L == timeout ? -1L : Math.min(Integer.MAX_VALUE, Math.max(0L, timeout - (System.currentTimeMillis() - startTime)));
                PcscStatus.check("ScardGetStatusChange.2", this.getIfdCollection().scardGetStatusChange(remaining, ifd));
            }
        }
        catch (PcscException e) {
            if (e.getCode() == -2146435062) {
                return false;
            }
            throw new CardException("waitForCard() failed", e);
        }
    }
}

