/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.pcsc;

import de.gematik.smartcards.pcsc.Icc;
import de.gematik.smartcards.sdcom.apdu.ApduLayer;
import de.gematik.smartcards.sdcom.apdu.CommandApdu;
import de.gematik.smartcards.sdcom.apdu.ResponseApdu;
import de.gematik.smartcards.sdcom.apdu.isoiec7816apdu.ManageChannel;
import de.gematik.smartcards.utils.Hex;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.jetbrains.annotations.VisibleForTesting;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public final class IccChannel
extends CardChannel
implements ApduLayer {
    private final int insChannelNumber;
    private final Icc insCard;
    private volatile double insTime;

    IccChannel(Icc icc, int channel) {
        this.insCard = icc;
        this.insChannelNumber = channel;
    }

    public byte[] send(byte[] command) {
        if (command[1] == 112) {
            throw new IllegalArgumentException("MANAGE CHANNEL command not allowed, use other methods: " + Hex.toHexDigits((byte[])command));
        }
        return this.send(command, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] send(byte[] command, boolean adjustChannelNumber) {
        double[] executionTime = new double[1];
        try {
            int channelNo = this.insChannelNumber;
            if (this.getCard().isClosed(channelNo)) {
                throw new IllegalStateException("Logical channel has been closed");
            }
            if (adjustChannelNumber) {
                CommandApdu cmdA = new CommandApdu(command);
                CommandApdu cmdB = cmdA.setChannelNumber(channelNo);
                command[0] = (byte)cmdB.getCla();
            }
            byte[] byArray = this.getCard().send(command, executionTime);
            return byArray;
        }
        finally {
            this.setTime(executionTime[0]);
        }
    }

    public ResponseApdu send(CommandApdu apdu) {
        if (apdu.getIns() == 112) {
            throw new IllegalArgumentException("MANAGE CHANNEL command not allowed, use other methods: " + String.valueOf(apdu));
        }
        return this.sendCmd(apdu);
    }

    ResponseApdu sendCmd(CommandApdu apdu) {
        CommandApdu cmd = apdu.setChannelNumber(this.insChannelNumber);
        this.getCard().getLogger().atDebug().log("cmd: {}", (Object)cmd.toString());
        ResponseApdu result = new ResponseApdu(this.send(cmd.getBytes(), false));
        this.getCard().getLogger().atDebug().log("rsp: {}", (Object)result.toString());
        return result;
    }

    @Override
    public ResponseAPDU transmit(CommandAPDU command) {
        return new ResponseAPDU(this.send(command.getBytes()));
    }

    @Override
    public int transmit(ByteBuffer command, ByteBuffer response) {
        if (command == response) {
            throw new IllegalArgumentException("command and response must not be the same object");
        }
        if (response.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        byte[] cmd = new byte[command.remaining()];
        command.get(cmd);
        byte[] rsp = this.send(cmd);
        if (response.remaining() < rsp.length) {
            throw new IllegalArgumentException("Insufficient space in response buffer");
        }
        response.put(rsp);
        return rsp.length;
    }

    @Override
    public void close() throws CardException {
        try {
            if (0 == this.insChannelNumber) {
                throw new IllegalStateException("Cannot close basic logical channel");
            }
            if (this.getCard().isClosed(this.insChannelNumber)) {
                return;
            }
            ResponseApdu rsp = this.sendCmd((CommandApdu)ManageChannel.CLOSE);
            if (36864 != rsp.getTrailer()) {
                throw new CardException("close() failed: " + String.valueOf(rsp));
            }
        }
        finally {
            this.getCard().insOpenChannels.remove(this.insChannelNumber);
        }
    }

    public void reset() throws CardException {
        ResponseApdu rsp = this.sendCmd((CommandApdu)ManageChannel.RESET_CHANNEL);
        if (36864 != rsp.getTrailer()) {
            throw new CardException("reset() failed: " + String.valueOf(rsp));
        }
    }

    @Override
    public Icc getCard() {
        return this.insCard;
    }

    @Override
    public int getChannelNumber() {
        this.getCard().checkState();
        if (this.getCard().isClosed(this.insChannelNumber)) {
            throw new IllegalStateException("Logical channel has been closed");
        }
        return this.insChannelNumber;
    }

    public double getTime() {
        return this.insTime;
    }

    @VisibleForTesting
    void setTime(double executionTime) {
        this.insTime = executionTime;
    }

    public String toString() {
        return String.valueOf(this.getCard()) + ", channelNumber " + this.insChannelNumber;
    }
}

