/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.pcsc;

import de.gematik.smartcards.pcsc.IccChannel;
import de.gematik.smartcards.pcsc.Ifd;
import de.gematik.smartcards.pcsc.PcscException;
import de.gematik.smartcards.pcsc.TransmitException;
import de.gematik.smartcards.pcsc.constants.PcscStatus;
import de.gematik.smartcards.pcsc.lib.Dword;
import de.gematik.smartcards.pcsc.lib.DwordByReference;
import de.gematik.smartcards.pcsc.lib.ScardHandle;
import de.gematik.smartcards.pcsc.lib.ScardHandleByReference;
import de.gematik.smartcards.sdcom.apdu.ApduLayer;
import de.gematik.smartcards.sdcom.apdu.CommandApdu;
import de.gematik.smartcards.sdcom.apdu.ResponseApdu;
import de.gematik.smartcards.sdcom.apdu.isoiec7816apdu.ManageChannel;
import de.gematik.smartcards.sdcom.isoiec7816objects.AnswerToReset;
import de.gematik.smartcards.utils.Hex;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public final class Icc
extends Card
implements ApduLayer {
    private static final Map<String, List<String>> NAME_SUBSTITUTION = Map.ofEntries(Map.entry("Alcor AU9560", List.of("Alcor Micro AU9560", "Generic EMV Smartcard Reader")), Map.entry("Cloud-2700", List.of("Identiv uTrust 2700 R Smart Card Reader [CCID Interface] (53691324212792)", "Identive CLOUD 2700 R Smart Card Reader [CCID Interface] (53691324212792)", "Identive CLOUD 2700 R Smart Card Reader")), Map.entry("Cloud4700-CB", List.of("Identive Identive CLOUD 4500 F Dual Interface Reader [CLOUD 4700 F Contact Reader] (53201326201956)")), Map.entry("Cloud4700-CL", List.of("Identive Identive CLOUD 4500 F Dual Interface Reader [CLOUD 4700 F Contactless Reader] (53201326201956)")), Map.entry("Omnikey-6121", List.of("HID Global OMNIKEY 6121 Smart Card Reader [OMNIKEY 6121 Smart Card Reader]", "HID Global OMNIKEY 6121 Smart Card Reader")), Map.entry("SCR-3310", List.of("SCM Microsystems Inc. SCR3310 USB Smart Card Reader", "SCM Microsystems Inc. SCR 3310 [CCID Interface] (00000000000000)")));
    private final AnswerToReset insAnswerToReset;
    private final IccChannel insBasicChannel;
    private final Ifd insIfd;
    private final Logger insLogger;
    final Set<Integer> insOpenChannels = new HashSet<Integer>();
    private final String insProtocol;
    private final ScardHandle insScardHandle;
    private volatile EafiState insState;
    private volatile double insTime;

    Icc(Ifd ifd, String protocol) throws PcscException {
        if (!"T=1".equals(protocol)) {
            throw new IllegalArgumentException("unsupported protocol: " + protocol);
        }
        this.insIfd = ifd;
        this.insProtocol = protocol;
        ScardHandleByReference phCard = new ScardHandleByReference();
        DwordByReference pdwActiveProtocol = new DwordByReference();
        PcscStatus.check("Icc: scardConnect", this.insIfd.getIfdCollection().scardConnect(this.getIfd().getName(), 1, 2, phCard, pdwActiveProtocol));
        this.insScardHandle = phCard.getValue();
        DwordByReference pdwState = new DwordByReference();
        DwordByReference pdwProtocol = new DwordByReference();
        byte[] atrBuffer = new byte[33];
        ByteBuffer pbAtr = ByteBuffer.wrap(atrBuffer);
        DwordByReference pcbAtrLen = new DwordByReference(new Dword(33L));
        PcscStatus.check("Icc: scardStatus", ifd.getIfdCollection().getLibrary().scardStatus(this.getScardHandle(), null, new DwordByReference(), pdwState, pdwProtocol, pbAtr, pcbAtrLen));
        this.insAnswerToReset = new AnswerToReset(Arrays.copyOfRange(atrBuffer, 0, pcbAtrLen.getValue().intValue()));
        String name = ifd.getName();
        String loggerName = NAME_SUBSTITUTION.entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().anyMatch(name::startsWith)).map(entry -> name.replace(((List)entry.getValue()).stream().filter(name::startsWith).findAny().orElse(name), (CharSequence)entry.getKey())).findAny().orElse(name);
        this.insLogger = LoggerFactory.getLogger((String)(Icc.class.getName() + "." + loggerName));
        this.insBasicChannel = new IccChannel(this, 0);
        this.insState = EafiState.OK;
    }

    void checkState() {
        switch (this.insState.ordinal()) {
            case 2: {
                throw new IllegalStateException("Card has been disconnected");
            }
            case 1: {
                throw new IllegalStateException("Card has been removed");
            }
        }
    }

    @Override
    public ATR getATR() {
        return new ATR(this.insAnswerToReset.getBytes());
    }

    public AnswerToReset getAnswerToReset() {
        return this.insAnswerToReset;
    }

    @Override
    public String getProtocol() {
        return this.insProtocol;
    }

    @Override
    public CardChannel getBasicChannel() {
        this.checkState();
        return this.insBasicChannel;
    }

    @Override
    public CardChannel openLogicalChannel() throws CardException {
        try {
            ResponseApdu rsp = this.send((CommandApdu)ManageChannel.OPEN);
            if (36864 != rsp.getTrailer()) {
                throw new CardException("openLogicalChannel() failed, card response: " + String.valueOf(rsp));
            }
            int channelNo = new BigInteger(rsp.getData()).intValueExact();
            this.insOpenChannels.add(channelNo);
            return new IccChannel(this, channelNo);
        }
        catch (TransmitException e) {
            throw new CardException("openLogicalChannel() failed", e);
        }
    }

    public void reset() {
        this.send((CommandApdu)ManageChannel.RESET_APPLICATION, new int[]{36864});
        this.insOpenChannels.clear();
    }

    boolean isClosed(int channelNumber) {
        this.checkState();
        return 0 != channelNumber && !this.insOpenChannels.contains(channelNumber);
    }

    @Override
    public void beginExclusive() throws CardException {
        throw new PcscException(0, "not (yet) implemented: beginExclusive()");
    }

    @Override
    public void endExclusive() throws CardException {
        throw new PcscException(0, "not (yet) implemented: endExclusive");
    }

    @Override
    public byte[] transmitControlCommand(int controlCode, byte[] command) throws CardException {
        throw new PcscException(0, "not (yet) implemented: transimitControlCommand(int, byte[]");
    }

    @Override
    public synchronized void disconnect(boolean reset) throws CardException {
        if (EafiState.OK != this.insState) {
            return;
        }
        this.insState = EafiState.DISCONNECTED;
        PcscStatus.check("Icc.disconnect", this.getIfd().getIfdCollection().getLibrary().scardDisconnect(this.getScardHandle(), reset ? 2 : 0));
    }

    Logger getLogger() {
        return this.insLogger;
    }

    public double getTime() {
        return this.insTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] send(byte[] command) {
        double[] executionTime = new double[1];
        try {
            byte[] byArray = this.send(command, executionTime);
            return byArray;
        }
        finally {
            this.setTime(executionTime[0]);
        }
    }

    byte[] send(byte[] command, double ... executionTime) {
        try {
            this.checkState();
            this.getLogger().atTrace().log("cmd: '{}'", (Object)Hex.toHexDigits((byte[])command));
            byte[] result = this.getIfd().getIfdCollection().getLibrary().scardTransmit(this.getScardHandle(), command, executionTime);
            double runTime = executionTime[0];
            this.getLogger().atTrace().log("rsp: {},  '{}'", (Object)String.format("time=%7.3f s", runTime), (Object)Hex.toHexDigits((byte[])result));
            return result;
        }
        catch (PcscException e) {
            if (e.getCode() == -2146434967) {
                this.insState = EafiState.REMOVED;
            }
            throw new TransmitException(e);
        }
    }

    public ResponseApdu send(CommandApdu apdu) {
        this.getLogger().atDebug().log("cmd: {}", (Object)apdu.toString());
        ResponseApdu result = new ResponseApdu(this.send(apdu.getBytes()));
        this.getLogger().atDebug().log("rsp: {}", (Object)result.toString());
        return result;
    }

    @VisibleForTesting
    void setTime(double executionTime) {
        this.insTime = executionTime;
    }

    Ifd getIfd() {
        return this.insIfd;
    }

    private ScardHandle getScardHandle() {
        return this.insScardHandle;
    }

    boolean isValid() {
        if (EafiState.OK != this.insState) {
            return false;
        }
        int code = this.getIfd().getIfdCollection().getLibrary().scardStatus(this.getScardHandle(), null, new DwordByReference(), new DwordByReference(), new DwordByReference(), ByteBuffer.allocate(33), new DwordByReference(new Dword(33L)));
        if (0 == code) {
            return true;
        }
        this.insState = EafiState.REMOVED;
        return false;
    }

    public String toString() {
        return "PC/SC ICC in " + this.getIfd().getName() + ", protocol " + this.getProtocol() + ", state " + String.valueOf((Object)this.insState);
    }

    private static enum EafiState {
        OK,
        REMOVED,
        DISCONNECTED;

    }
}

