/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv.valmodule.base.helper;

import de.gematik.refv.commons.validation.IntegratedValidationModule;
import de.gematik.refv.commons.validation.ValidationResult;
import de.gematik.refv.valmodule.base.helper.TestConfigurationBasedValidationModuleFactory;
import de.gematik.refv.valmodule.base.helper.ValidFolderDetector;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.CONCURRENT)
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class BaseProfileIntegrationTest {
    protected IntegratedValidationModule validationModule;

    protected void createValidationModule(String module) {
        this.validationModule = TestConfigurationBasedValidationModuleFactory.createInstance(module);
    }

    protected void validateFile(Path path) {
        ValidationResult result = this.validationModule.validateFile(path);
        boolean isValid = ValidFolderDetector.isInValidFolder(path);
        Assertions.assertEquals((Object)isValid, (Object)result.isValid(), (String)result.toString());
    }

    protected Stream<DynamicTest> testValidationBase(String folder) {
        return this.testValidationBase(folder, "xml");
    }

    protected Stream<DynamicTest> testValidationBase(String folder, String fileExtension) {
        return Files.walk(Paths.get(String.format("src/test/resources/%s", folder), new String[0]), new FileVisitOption[0]).filter(path -> path.toString().endsWith(String.format(".%s", fileExtension))).map(f -> DynamicTest.dynamicTest((String)f.toString(), () -> this.validateFile((Path)f)));
    }
}

