/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv.valmodule.base.helper;

import de.gematik.refv.commons.validation.ValidationResult;
import de.gematik.refv.valmodule.base.ConfigurationBasedValidationModule;
import de.gematik.refv.valmodule.base.helper.TestConfigurationBasedValidationModuleFactory;
import de.gematik.refv.valmodule.base.helper.ValidFolderDetector;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;

public abstract class BaseProfileIntegrationTest {
    protected ConfigurationBasedValidationModule validationModule;

    protected void createValidationModule(String module) {
        this.validationModule = TestConfigurationBasedValidationModuleFactory.createInstance(module);
    }

    protected void createValidationModuleNonCachingInstance(String module) {
        this.validationModule = TestConfigurationBasedValidationModuleFactory.createNonCachingInstance(module);
    }

    private void validateFile(Path path) {
        ValidationResult result = this.validationModule.validateFile(path);
        boolean isValid = ValidFolderDetector.isInValidFolder(path);
        Assertions.assertEquals((Object)isValid, (Object)result.isValid(), (String)result.toString());
    }

    protected Stream<DynamicTest> testValidationBase(String folder) {
        return this.testValidationBase(folder, "xml");
    }

    protected Stream<DynamicTest> testValidationBase(String folder, String fileExtension) {
        return Files.walk(Paths.get(String.format("src/test/resources/%s", folder), new String[0]), new FileVisitOption[0]).filter(path -> path.toString().endsWith(String.format(".%s", fileExtension))).map(f -> DynamicTest.dynamicTest((String)f.toString(), () -> this.validateFile((Path)f)));
    }
}

