/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv.valmodule.base;

import ca.uhn.fhir.context.FhirContext;
import de.gematik.refv.commons.ReferencedProfileLocator;
import de.gematik.refv.commons.configuration.FhirPackageConfigurationLoader;
import de.gematik.refv.commons.exceptions.ValidationModuleInitializationException;
import de.gematik.refv.commons.validation.GenericValidator;
import de.gematik.refv.commons.validation.GenericValidatorFactory;
import de.gematik.refv.commons.validation.ProfileCacheStrategy;
import de.gematik.refv.commons.validation.SeverityLevelTransformer;
import de.gematik.refv.commons.validation.ValidationResult;
import de.gematik.refv.valmodule.base.ConfigurationBasedValidationModule;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class ConfigurationBasedValidationModuleTests {
    private static GenericValidator engine;

    ConfigurationBasedValidationModuleTests() {
    }

    @BeforeAll
    static void beforeAll() {
        engine = new GenericValidator(FhirContext.forR4(), new ReferencedProfileLocator(), new GenericValidatorFactory(), new SeverityLevelTransformer(), ProfileCacheStrategy.CACHE_PROFILES);
    }

    @Test
    void testValidateFileValidNoCache() throws IOException, ValidationModuleInitializationException {
        GenericValidator genericValidator = new GenericValidator(FhirContext.forR4(), new ReferencedProfileLocator(), new GenericValidatorFactory(), new SeverityLevelTransformer(), ProfileCacheStrategy.NO_CACHE);
        ConfigurationBasedValidationModule validationModule = new ConfigurationBasedValidationModule("minimal", new FhirPackageConfigurationLoader(), genericValidator);
        validationModule.initialize();
        ValidationResult result = validationModule.validateFile("src/test/resources/test-minimal-example-valid.xml");
        Assertions.assertTrue((boolean)result.isValid(), (String)result.toString());
    }

    @Test
    void testValidateFileValid() throws IOException, ValidationModuleInitializationException {
        ConfigurationBasedValidationModule validationModule = new ConfigurationBasedValidationModule("minimal", new FhirPackageConfigurationLoader(), engine);
        validationModule.initialize();
        ValidationResult result = validationModule.validateFile("src/test/resources/test-minimal-example-valid.xml");
        Assertions.assertTrue((boolean)result.isValid(), (String)result.toString());
    }

    @Test
    void testValidateStringValid() throws IOException, ValidationModuleInitializationException {
        ConfigurationBasedValidationModule validationModule = new ConfigurationBasedValidationModule("minimal", new FhirPackageConfigurationLoader(), engine);
        validationModule.initialize();
        String fhirResourceAsString = Files.readString(Path.of("src/test/resources/test-minimal-example-valid.xml", new String[0]), StandardCharsets.UTF_8);
        ValidationResult result = validationModule.validateString(fhirResourceAsString);
        Assertions.assertTrue((boolean)result.isValid(), (String)result.toString());
    }

    @Test
    void testValidateFileWithPathValid() throws IOException, ValidationModuleInitializationException {
        ConfigurationBasedValidationModule validationModule = new ConfigurationBasedValidationModule("minimal", new FhirPackageConfigurationLoader(), engine);
        validationModule.initialize();
        ValidationResult result = validationModule.validateFile(Path.of("src/test/resources/test-minimal-example-valid.xml", new String[0]));
        Assertions.assertTrue((boolean)result.isValid(), (String)result.toString());
    }

    @Test
    void testValidateFileInvalid() throws IOException, ValidationModuleInitializationException {
        ConfigurationBasedValidationModule validationModule = new ConfigurationBasedValidationModule("minimal", new FhirPackageConfigurationLoader(), engine);
        validationModule.initialize();
        ValidationResult result = validationModule.validateFile("src/test/resources/test-minimal-example-invalid.xml");
        Assertions.assertFalse((boolean)result.isValid(), (String)result.toString());
    }

    @Test
    void testInitialize() {
        ConfigurationBasedValidationModule validationModule = new ConfigurationBasedValidationModule("minimal", new FhirPackageConfigurationLoader(), engine);
        Assertions.assertDoesNotThrow(() -> ((ConfigurationBasedValidationModule)validationModule).initialize());
    }

    @Test
    void testCreateInstanceWithNonExistingModule() {
        FhirPackageConfigurationLoader fhirPackageConfigurationLoader = new FhirPackageConfigurationLoader();
        ConfigurationBasedValidationModule validationModule = new ConfigurationBasedValidationModule("non-existing-module", fhirPackageConfigurationLoader, engine);
        Assertions.assertThrows(ValidationModuleInitializationException.class, () -> ((ConfigurationBasedValidationModule)validationModule).initialize());
    }
}

