/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv.snapshots.helper;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.hapi.converters.canonical.VersionCanonicalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.common.hapi.validation.support.SnapshotGeneratingValidationSupport;
import org.hl7.fhir.common.hapi.validation.validator.ProfileKnowledgeWorkerR5;
import org.hl7.fhir.common.hapi.validation.validator.VersionSpecificWorkerContextWrapper;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r5.conformance.profile.ProfileKnowledgeProvider;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedSnapshotGeneratingValidationSupport
extends SnapshotGeneratingValidationSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FixedSnapshotGeneratingValidationSupport.class);
    private final FhirContext myCtx;
    private final VersionCanonicalizer myVersionCanonicalizer;

    public FixedSnapshotGeneratingValidationSupport(FhirContext theCtx) {
        super(theCtx);
        this.myCtx = theCtx;
        this.myVersionCanonicalizer = new VersionCanonicalizer(theCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IBaseResource generateSnapshot(ValidationSupportContext theValidationSupportContext, IBaseResource theInput, String theUrl, String theWebUrl, String theProfileName) {
        FhirVersionEnum version = theInput.getStructureFhirVersionEnum();
        assert (version == this.myCtx.getVersion().getVersion());
        Validate.notNull((Object)this.myVersionCanonicalizer, (String)"Can not generate snapshot for version: %s", (Object[])new Object[]{version});
        org.hl7.fhir.r5.model.StructureDefinition inputCanonical = this.myVersionCanonicalizer.structureDefinitionToCanonical(theInput);
        String inputUrl = inputCanonical.getUrl();
        if (!inputCanonical.getSnapshot().getElement().isEmpty()) {
            log.info("A snapshot already exists for: {}", (Object)inputUrl);
            return theInput;
        }
        if (theValidationSupportContext.getCurrentlyGeneratingSnapshots().contains(inputUrl)) {
            log.debug("Detected circular dependency, already generating snapshot for: {}", (Object)inputUrl);
            return theInput;
        }
        theValidationSupportContext.getCurrentlyGeneratingSnapshots().add(inputUrl);
        try {
            String baseDefinition = inputCanonical.getBaseDefinition();
            if (StringUtils.isBlank((CharSequence)baseDefinition)) {
                throw new PreconditionFailedException("StructureDefinition[id=" + inputCanonical.getIdElement().getId() + ", url=" + inputCanonical.getUrl() + "] has no base");
            }
            IBaseResource base = theValidationSupportContext.getRootValidationSupport().fetchStructureDefinition(baseDefinition);
            if (base == null) {
                throw new PreconditionFailedException("Unknown base definition: " + baseDefinition);
            }
            org.hl7.fhir.r5.model.StructureDefinition baseCanonical = this.myVersionCanonicalizer.structureDefinitionToCanonical(base);
            if (baseCanonical.getSnapshot().getElement().isEmpty()) {
                theValidationSupportContext.getRootValidationSupport().generateSnapshot(theValidationSupportContext, base, null, null, null);
                baseCanonical = this.myVersionCanonicalizer.structureDefinitionToCanonical(base);
            }
            ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
            ProfileKnowledgeWorkerR5 profileKnowledgeProvider = new ProfileKnowledgeWorkerR5(this.myCtx);
            VersionSpecificWorkerContextWrapper context = new VersionSpecificWorkerContextWrapper(theValidationSupportContext, this.myVersionCanonicalizer);
            ProfileUtilities profileUtilities = new ProfileUtilities((IWorkerContext)context, messages, (ProfileKnowledgeProvider)profileKnowledgeProvider);
            profileUtilities.setThrowException(true);
            profileUtilities.generateSnapshot(baseCanonical, inputCanonical, theUrl, theWebUrl, theProfileName);
            this.logValidationMessages(messages, inputUrl);
            List errors = messages.stream().filter(m -> m.getLevel().isError()).collect(Collectors.toList());
            if (!errors.isEmpty()) {
                throw new DefinitionException("Could not generate snapshot for " + inputUrl);
            }
            StructureDefinition generatedR4 = (StructureDefinition)this.myVersionCanonicalizer.structureDefinitionFromCanonical(inputCanonical);
            ((StructureDefinition)theInput).getSnapshot().getElement().clear();
            ((StructureDefinition)theInput).getSnapshot().getElement().addAll(generatedR4.getSnapshot().getElement());
        }
        finally {
            theValidationSupportContext.getCurrentlyGeneratingSnapshots().remove(inputUrl);
        }
        return theInput;
    }

    private void logValidationMessages(ArrayList<ValidationMessage> messages, String inputUrl) {
        for (ValidationMessage e : messages) {
            if (e.getLevel().isError()) {
                log.error("Error while snapshot generation for {} : {}", (Object)inputUrl, (Object)e);
                continue;
            }
            if (e.getLevel() == ValidationMessage.IssueSeverity.WARNING) {
                log.warn("Warning while snapshot generation for {} : {}", (Object)inputUrl, (Object)e);
                continue;
            }
            log.info("Info while snapshot generation for {} : {}", (Object)inputUrl, (Object)e);
        }
    }
}

