/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv.plugins.validation;

import ca.uhn.fhir.context.FhirContext;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.gematik.refv.commons.configuration.ValidationModuleConfiguration;
import de.gematik.refv.commons.validation.BaseValidationResourceProvider;
import de.gematik.refv.plugins.configuration.v1.ValidationModuleConfigurationFactory;
import de.gematik.refv.plugins.configuration.v2.PluginDefinition;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginValidationResourceProvider
extends BaseValidationResourceProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginValidationResourceProvider.class);
    private static final String CONFIG_FILE = "config.yaml";
    private final Function<String, InputStream> resourceLoaderFunction;
    private final FhirContext fhirContext;
    private volatile ValidationModuleConfiguration cachedConfiguration;
    private final Object lockObject = new Object();

    public PluginValidationResourceProvider(Function<String, InputStream> resourceLoaderFunction, FhirContext fhirContext) {
        super(resourceLoaderFunction);
        this.resourceLoaderFunction = resourceLoaderFunction;
        this.fhirContext = fhirContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationModuleConfiguration getConfiguration() {
        if (this.cachedConfiguration == null) {
            Object object = this.lockObject;
            synchronized (object) {
                block16: {
                    if (this.cachedConfiguration == null) {
                        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                        try (InputStream pluginDefinitionFile = this.getResource(CONFIG_FILE);){
                            String yamlContent = new String(pluginDefinitionFile.readAllBytes());
                            Map jsonMap = (Map)mapper.readValue(yamlContent, Map.class);
                            Object specVersion = jsonMap.get("configSpecVersion");
                            if (specVersion == null) {
                                throw new IllegalArgumentException("Could not determine config file spec version");
                            }
                            if (specVersion.toString().startsWith("1.")) {
                                de.gematik.refv.plugins.configuration.v1.PluginDefinition pluginDefinitionV1 = (de.gematik.refv.plugins.configuration.v1.PluginDefinition)mapper.readValue(yamlContent, de.gematik.refv.plugins.configuration.v1.PluginDefinition.class);
                                this.cachedConfiguration = ValidationModuleConfigurationFactory.createFrom(pluginDefinitionV1, this.fhirContext, this.resourceLoaderFunction);
                                break block16;
                            }
                            if (specVersion.toString().startsWith("2.")) {
                                PluginDefinition pluginDefinitionV2 = (PluginDefinition)mapper.readValue(yamlContent, PluginDefinition.class);
                                this.cachedConfiguration = de.gematik.refv.plugins.configuration.v2.ValidationModuleConfigurationFactory.createFrom(pluginDefinitionV2, this.fhirContext, this.resourceLoaderFunction);
                                break block16;
                            }
                            throw new IllegalArgumentException("Unsupported config file spec version: " + String.valueOf(specVersion));
                        }
                    }
                }
            }
        }
        return this.cachedConfiguration;
    }
}

