/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv.plugins.configuration.v2;

import ca.uhn.fhir.context.FhirContext;
import de.gematik.refv.commons.configuration.ProfileConfiguration;
import de.gematik.refv.commons.configuration.SupportedProfileVersions;
import de.gematik.refv.commons.configuration.ValidationModuleConfiguration;
import de.gematik.refv.plugins.configuration.DependencyList;
import de.gematik.refv.plugins.configuration.FhirPackage;
import de.gematik.refv.plugins.configuration.ValidationModuleConfigurationSupportedProfilesBuilder;
import de.gematik.refv.plugins.configuration.v2.PluginDefinition;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidationModuleConfigurationFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidationModuleConfigurationFactory.class);

    public static ValidationModuleConfiguration createFrom(PluginDefinition pluginDefinition, FhirContext context, Function<String, InputStream> resourceLoaderFunction) throws IOException {
        ValidationModuleConfigurationSupportedProfilesBuilder supportedProfilesBuilder = new ValidationModuleConfigurationSupportedProfilesBuilder(context, resourceLoaderFunction);
        ValidationModuleConfiguration.ValidationModuleConfigurationBuilder builder = ValidationModuleConfiguration.builder();
        builder.id(pluginDefinition.getId()).acceptedEncodings(pluginDefinition.getValidation().getAcceptedEncodings() != null ? pluginDefinition.getValidation().getAcceptedEncodings() : new ArrayList()).anyExtensionsAllowed(pluginDefinition.getValidation().isAnyExtensionsAllowed()).errorOnUnknownProfile(pluginDefinition.getValidation().isErrorOnUnknownProfile()).version(pluginDefinition.getVersion()).ignoredCodeSystems(pluginDefinition.getValidation().getIgnoredCodeSystems() != null ? pluginDefinition.getValidation().getIgnoredCodeSystems() : new ArrayList()).ignoredValueSets(pluginDefinition.getValidation().getIgnoredValueSets() != null ? pluginDefinition.getValidation().getIgnoredValueSets() : new ArrayList());
        builder.dependencyLists(ValidationModuleConfigurationFactory.createDependencyListsSection(pluginDefinition));
        builder.supportedProfiles(ValidationModuleConfigurationFactory.createSupportedProfilesSection(pluginDefinition, supportedProfilesBuilder));
        return builder.build();
    }

    private static Map<String, SupportedProfileVersions> createSupportedProfilesSection(PluginDefinition pluginDefinition, ValidationModuleConfigurationSupportedProfilesBuilder supportedProfilesBuilder) throws IOException {
        HashMap<String, Map<String, ProfileConfiguration>> supportedProfiles = new HashMap<String, Map<String, ProfileConfiguration>>();
        for (DependencyList dl : pluginDefinition.getValidation().getDependencyLists()) {
            Map<String, Map<String, ProfileConfiguration>> sp = supportedProfilesBuilder.buildSupportedProfilesMap(dl.getFhirPackage(), dl.getCreationDateLocators());
            for (Map.Entry<String, Map<String, ProfileConfiguration>> entry : sp.entrySet()) {
                ValidationModuleConfigurationFactory.addNewSupportedProfilesToMap(entry.getKey(), entry.getValue(), supportedProfiles);
            }
        }
        return supportedProfiles.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new SupportedProfileVersions((Map)e.getValue())));
    }

    private static void addNewSupportedProfilesToMap(String profile, Map<String, ProfileConfiguration> newProfileVersions, Map<String, Map<String, ProfileConfiguration>> supportedProfiles) {
        supportedProfiles.compute(profile, (p, existingProfileVersions) -> {
            if (existingProfileVersions == null) {
                return newProfileVersions;
            }
            ValidationModuleConfigurationFactory.mergeProfileVersions(existingProfileVersions, newProfileVersions, profile);
            return existingProfileVersions;
        });
    }

    private static void mergeProfileVersions(Map<String, ProfileConfiguration> existingProfileVersions, Map<String, ProfileConfiguration> newProfileVersions, String profile) {
        for (Map.Entry<String, ProfileConfiguration> newProfileVersion : newProfileVersions.entrySet()) {
            if (!existingProfileVersions.containsKey(newProfileVersion.getKey())) {
                existingProfileVersions.put(newProfileVersion.getKey(), newProfileVersion.getValue());
                continue;
            }
            ProfileConfiguration existingProfileConfiguration = existingProfileVersions.get(newProfileVersion.getKey());
            ArrayList combinedDependencyList = new ArrayList(existingProfileConfiguration.getDependencyLists());
            combinedDependencyList.addAll(newProfileVersion.getValue().getDependencyLists());
            if (!Objects.equals(newProfileVersion.getValue().getCreationDateLocator(), existingProfileConfiguration.getCreationDateLocator())) {
                throw new IllegalArgumentException("Multiple creation date locators defined for profile: " + profile + ". Configuration for version-less canonicals can not be created");
            }
            existingProfileVersions.put(newProfileVersion.getKey(), new ProfileConfiguration(combinedDependencyList, newProfileVersion.getValue().getCreationDateLocator()));
        }
    }

    private static Map<String, de.gematik.refv.commons.configuration.DependencyList> createDependencyListsSection(PluginDefinition pluginDefinition) {
        HashMap<String, de.gematik.refv.commons.configuration.DependencyList> dependencyLists = new HashMap<String, de.gematik.refv.commons.configuration.DependencyList>();
        pluginDefinition.getValidation().getDependencyLists().stream().forEach(dl -> {
            de.gematik.refv.commons.configuration.DependencyList dependencyList = ValidationModuleConfigurationFactory.createDependencyListSectionPart(dl);
            dependencyLists.put(dl.getFhirPackage().toNameAndVersion(), dependencyList);
        });
        return dependencyLists;
    }

    private static de.gematik.refv.commons.configuration.DependencyList createDependencyListSectionPart(DependencyList dl) {
        ArrayList<String> dependencies = new ArrayList<String>();
        dependencies.add(dl.getFhirPackage().toFilename());
        if (dl.getDependencies() != null) {
            dependencies.addAll(dl.getDependencies().stream().map(FhirPackage::toFilename).collect(Collectors.toList()));
        }
        List distinctDependencies = dependencies.stream().distinct().collect(Collectors.toList());
        return new de.gematik.refv.commons.configuration.DependencyList(dl.getValidFrom(), dl.getValidTill(), distinctDependencies, dl.getValidationMessageTransformations() != null ? dl.getValidationMessageTransformations() : new ArrayList());
    }

    @Generated
    private ValidationModuleConfigurationFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

