/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv.plugins.configuration.v1;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.gematik.refv.commons.configuration.ValidationMessageTransformation;
import de.gematik.refv.plugins.configuration.FhirPackage;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ValidationSection {
    @NonNull
    private FhirPackage fhirPackage;
    private List<FhirPackage> dependencies;
    private boolean errorOnUnknownProfile;
    private boolean anyExtensionsAllowed;
    private List<String> acceptedEncodings;
    private List<ValidationMessageTransformation> validationMessageTransformations;
    private List<String> ignoredCodeSystems;
    private List<String> ignoredValueSets;

    public List<ValidationMessageTransformation> getValidationMessageTransformations() {
        return Collections.unmodifiableList(Objects.requireNonNullElseGet(this.validationMessageTransformations, LinkedList::new));
    }

    public List<FhirPackage> getDependencies() {
        return Collections.unmodifiableList(Objects.requireNonNullElseGet(this.dependencies, LinkedList::new));
    }

    public List<String> getAcceptedEncodings() {
        return Collections.unmodifiableList(Objects.requireNonNullElseGet(this.acceptedEncodings, LinkedList::new));
    }

    public List<String> getIgnoredCodeSystems() {
        return Collections.unmodifiableList(Objects.requireNonNullElseGet(this.ignoredCodeSystems, LinkedList::new));
    }

    public List<String> getIgnoredValueSets() {
        return Collections.unmodifiableList(Objects.requireNonNullElseGet(this.ignoredValueSets, LinkedList::new));
    }

    @NonNull
    @Generated
    public FhirPackage getFhirPackage() {
        return this.fhirPackage;
    }

    @Generated
    public boolean isErrorOnUnknownProfile() {
        return this.errorOnUnknownProfile;
    }

    @Generated
    public boolean isAnyExtensionsAllowed() {
        return this.anyExtensionsAllowed;
    }

    @Generated
    private void setFhirPackage(@NonNull FhirPackage fhirPackage) {
        if (fhirPackage == null) {
            throw new NullPointerException("fhirPackage is marked non-null but is null");
        }
        this.fhirPackage = fhirPackage;
    }

    @Generated
    private void setDependencies(List<FhirPackage> dependencies) {
        this.dependencies = dependencies;
    }

    @Generated
    private void setErrorOnUnknownProfile(boolean errorOnUnknownProfile) {
        this.errorOnUnknownProfile = errorOnUnknownProfile;
    }

    @Generated
    private void setAnyExtensionsAllowed(boolean anyExtensionsAllowed) {
        this.anyExtensionsAllowed = anyExtensionsAllowed;
    }

    @Generated
    private void setAcceptedEncodings(List<String> acceptedEncodings) {
        this.acceptedEncodings = acceptedEncodings;
    }

    @Generated
    private void setValidationMessageTransformations(List<ValidationMessageTransformation> validationMessageTransformations) {
        this.validationMessageTransformations = validationMessageTransformations;
    }

    @Generated
    private void setIgnoredCodeSystems(List<String> ignoredCodeSystems) {
        this.ignoredCodeSystems = ignoredCodeSystems;
    }

    @Generated
    private void setIgnoredValueSets(List<String> ignoredValueSets) {
        this.ignoredValueSets = ignoredValueSets;
    }

    @ConstructorProperties(value={"fhirPackage", "dependencies", "errorOnUnknownProfile", "anyExtensionsAllowed", "acceptedEncodings", "validationMessageTransformations", "ignoredCodeSystems", "ignoredValueSets"})
    @Generated
    public ValidationSection(@NonNull FhirPackage fhirPackage, List<FhirPackage> dependencies, boolean errorOnUnknownProfile, boolean anyExtensionsAllowed, List<String> acceptedEncodings, List<ValidationMessageTransformation> validationMessageTransformations, List<String> ignoredCodeSystems, List<String> ignoredValueSets) {
        if (fhirPackage == null) {
            throw new NullPointerException("fhirPackage is marked non-null but is null");
        }
        this.fhirPackage = fhirPackage;
        this.dependencies = dependencies;
        this.errorOnUnknownProfile = errorOnUnknownProfile;
        this.anyExtensionsAllowed = anyExtensionsAllowed;
        this.acceptedEncodings = acceptedEncodings;
        this.validationMessageTransformations = validationMessageTransformations;
        this.ignoredCodeSystems = ignoredCodeSystems;
        this.ignoredValueSets = ignoredValueSets;
    }
}

