/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv.plugins.configuration.v1;

import ca.uhn.fhir.context.FhirContext;
import de.gematik.refv.commons.configuration.DependencyList;
import de.gematik.refv.commons.configuration.ProfileConfiguration;
import de.gematik.refv.commons.configuration.SupportedProfileVersions;
import de.gematik.refv.commons.configuration.ValidationModuleConfiguration;
import de.gematik.refv.plugins.configuration.CreationDateLocator;
import de.gematik.refv.plugins.configuration.FhirPackage;
import de.gematik.refv.plugins.configuration.ValidationModuleConfigurationSupportedProfilesBuilder;
import de.gematik.refv.plugins.configuration.v1.PluginDefinition;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

public final class ValidationModuleConfigurationFactory {
    public static ValidationModuleConfiguration createFrom(PluginDefinition pluginDefinition, FhirContext context, Function<String, InputStream> resourceLoaderFunction) throws IOException {
        ValidationModuleConfigurationSupportedProfilesBuilder supportedProfilesBuilder = new ValidationModuleConfigurationSupportedProfilesBuilder(context, resourceLoaderFunction);
        ValidationModuleConfiguration.ValidationModuleConfigurationBuilder builder = ValidationModuleConfiguration.builder();
        builder.id(pluginDefinition.getId()).acceptedEncodings(pluginDefinition.getValidation().getAcceptedEncodings() != null ? pluginDefinition.getValidation().getAcceptedEncodings() : new ArrayList()).anyExtensionsAllowed(pluginDefinition.getValidation().isAnyExtensionsAllowed()).errorOnUnknownProfile(pluginDefinition.getValidation().isErrorOnUnknownProfile()).version(pluginDefinition.getVersion()).ignoredCodeSystems(pluginDefinition.getValidation().getIgnoredCodeSystems() != null ? pluginDefinition.getValidation().getIgnoredCodeSystems() : new ArrayList()).ignoredValueSets(pluginDefinition.getValidation().getIgnoredValueSets() != null ? pluginDefinition.getValidation().getIgnoredValueSets() : new ArrayList());
        ArrayList<String> dependencies = new ArrayList<String>();
        dependencies.add(pluginDefinition.getValidation().getFhirPackage().toFilename());
        if (pluginDefinition.getValidation().getDependencies() != null) {
            dependencies.addAll(pluginDefinition.getValidation().getDependencies().stream().map(FhirPackage::toFilename).collect(Collectors.toList()));
        }
        List distinctDependencies = dependencies.stream().distinct().collect(Collectors.toList());
        HashMap<String, DependencyList> dependencyLists = new HashMap<String, DependencyList>();
        DependencyList dependencyList = new DependencyList("", "", distinctDependencies, pluginDefinition.getValidation().getValidationMessageTransformations() != null ? pluginDefinition.getValidation().getValidationMessageTransformations() : new ArrayList());
        dependencyLists.put(pluginDefinition.getValidation().getFhirPackage().toNameAndVersion(), dependencyList);
        builder.dependencyLists(dependencyLists);
        Map<String, Map<String, ProfileConfiguration>> supportedProfiles = supportedProfilesBuilder.buildSupportedProfilesMap(pluginDefinition.getValidation().getFhirPackage(), new LinkedList<CreationDateLocator>());
        Map<String, SupportedProfileVersions> supportedProfilesSection = supportedProfiles.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new SupportedProfileVersions((Map)e.getValue())));
        builder.supportedProfiles(supportedProfilesSection);
        return builder.build();
    }

    @Generated
    private ValidationModuleConfigurationFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

