/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv.plugins.configuration;

import ca.uhn.fhir.context.FhirContext;
import de.gematik.refv.commons.Profile;
import de.gematik.refv.commons.configuration.ProfileConfiguration;
import de.gematik.refv.commons.validation.support.CustomNpmPackageValidationSupport;
import de.gematik.refv.plugins.configuration.CreationDateLocator;
import de.gematik.refv.plugins.configuration.FhirPackage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;

public class ValidationModuleConfigurationSupportedProfilesBuilder {
    private final FhirContext fhirContext;
    private final Function<String, InputStream> resourceLoaderFunction;

    public ValidationModuleConfigurationSupportedProfilesBuilder(FhirContext fhirContext, Function<String, InputStream> resourceLoaderFunction) {
        this.fhirContext = fhirContext;
        this.resourceLoaderFunction = resourceLoaderFunction;
    }

    public Map<String, Map<String, ProfileConfiguration>> buildSupportedProfilesMap(@NonNull FhirPackage fhirPackage, List<CreationDateLocator> creationDateLocators) throws IOException {
        if (fhirPackage == null) {
            throw new NullPointerException("fhirPackage is marked non-null but is null");
        }
        CustomNpmPackageValidationSupport customNpmPackageValidationSupport = CustomNpmPackageValidationSupport.create((FhirContext)this.fhirContext, (String)fhirPackage.toFilename(), this.resourceLoaderFunction);
        Collection allProfiles = customNpmPackageValidationSupport.getAllProfiles();
        HashMap<String, Map<String, ProfileConfiguration>> supportedProfiles = new HashMap<String, Map<String, ProfileConfiguration>>();
        if (allProfiles != null) {
            for (Profile definition : allProfiles) {
                Optional<Object> creationDateLocator = creationDateLocators == null ? Optional.empty() : creationDateLocators.stream().filter(locator -> locator.getProfile().equals(definition.getBaseCanonical())).map(CreationDateLocator::getFhirPath).findFirst();
                ProfileConfiguration profileConfiguration = new ProfileConfiguration(List.of(fhirPackage.toNameAndVersion()), (String)creationDateLocator.orElse(null));
                HashMap<String, ProfileConfiguration> profileVersions = new HashMap<String, ProfileConfiguration>();
                profileVersions.put(definition.getVersion(), profileConfiguration);
                ValidationModuleConfigurationSupportedProfilesBuilder.addVersionWithoutPatchnumber(definition.getVersion(), profileVersions, profileConfiguration);
                profileVersions.put("0.0.0", profileConfiguration);
                supportedProfiles.put(definition.getBaseCanonical(), profileVersions);
            }
        }
        return supportedProfiles;
    }

    private static void addVersionWithoutPatchnumber(String profileVersion, Map<String, ProfileConfiguration> profileVersions, ProfileConfiguration profileConfiguration) {
        if (profileVersion.matches("\\d+\\.\\d+\\.\\d+")) {
            String[] versionParts = profileVersion.split("\\.");
            String majorMinorVersion = versionParts[0] + "." + versionParts[1];
            profileVersions.put(majorMinorVersion, profileConfiguration);
        }
    }
}

