/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv.plugins.configuration;

import de.gematik.refv.plugins.configuration.MalformedPackageDeclarationException;
import lombok.Generated;

public class FhirPackage {
    private static final String MALFORMED_PACKAGE_DECLARATION_TEXT = "Malformed package name '%s' (expected format: packageName#packageVersion)";
    private static final String PACKAGE_FILENAME_FORMATTER = "%s-%s.tgz";
    private static final String PACKAGE_NAMEVERSION_FORMATTER = "%s#%s";
    private final String name;
    private final String version;

    public FhirPackage(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public FhirPackage(String fhirPackageNameAndVersionWithRouteSeparator) {
        String[] validationFhirPackageNameAndVersion = fhirPackageNameAndVersionWithRouteSeparator.split("#");
        if (validationFhirPackageNameAndVersion.length < 2) {
            throw new MalformedPackageDeclarationException(String.format(MALFORMED_PACKAGE_DECLARATION_TEXT, fhirPackageNameAndVersionWithRouteSeparator));
        }
        this.name = validationFhirPackageNameAndVersion[0];
        this.version = validationFhirPackageNameAndVersion[1];
    }

    public String toNameAndVersion() {
        return String.format(PACKAGE_NAMEVERSION_FORMATTER, this.name, this.version);
    }

    public String toFilename() {
        return String.format(PACKAGE_FILENAME_FORMATTER, this.name, this.version);
    }

    public String toString() {
        return this.toNameAndVersion();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FhirPackage)) {
            return false;
        }
        FhirPackage other = (FhirPackage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FhirPackage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }
}

