/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv.plugins.configuration;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.gematik.refv.commons.configuration.ValidationMessageTransformation;
import de.gematik.refv.plugins.configuration.CreationDateLocator;
import de.gematik.refv.plugins.configuration.FhirPackage;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DependencyList {
    @NonNull
    private FhirPackage fhirPackage;
    private List<FhirPackage> dependencies;
    private List<ValidationMessageTransformation> validationMessageTransformations;
    private String validFrom;
    private String validTill;
    private List<CreationDateLocator> creationDateLocators;

    public List<FhirPackage> getDependencies() {
        return Collections.unmodifiableList(Objects.requireNonNullElseGet(this.dependencies, LinkedList::new));
    }

    public List<ValidationMessageTransformation> getValidationMessageTransformations() {
        return Collections.unmodifiableList(Objects.requireNonNullElseGet(this.validationMessageTransformations, LinkedList::new));
    }

    public List<CreationDateLocator> getCreationDateLocators() {
        return Collections.unmodifiableList(Objects.requireNonNullElseGet(this.creationDateLocators, LinkedList::new));
    }

    @NonNull
    @Generated
    public FhirPackage getFhirPackage() {
        return this.fhirPackage;
    }

    @Generated
    public String getValidFrom() {
        return this.validFrom;
    }

    @Generated
    public String getValidTill() {
        return this.validTill;
    }

    @Generated
    private void setFhirPackage(@NonNull FhirPackage fhirPackage) {
        if (fhirPackage == null) {
            throw new NullPointerException("fhirPackage is marked non-null but is null");
        }
        this.fhirPackage = fhirPackage;
    }

    @Generated
    private void setDependencies(List<FhirPackage> dependencies) {
        this.dependencies = dependencies;
    }

    @Generated
    private void setValidationMessageTransformations(List<ValidationMessageTransformation> validationMessageTransformations) {
        this.validationMessageTransformations = validationMessageTransformations;
    }

    @Generated
    private void setValidFrom(String validFrom) {
        this.validFrom = validFrom;
    }

    @Generated
    private void setValidTill(String validTill) {
        this.validTill = validTill;
    }

    @Generated
    private void setCreationDateLocators(List<CreationDateLocator> creationDateLocators) {
        this.creationDateLocators = creationDateLocators;
    }

    @ConstructorProperties(value={"fhirPackage", "dependencies", "validationMessageTransformations", "validFrom", "validTill", "creationDateLocators"})
    @Generated
    public DependencyList(@NonNull FhirPackage fhirPackage, List<FhirPackage> dependencies, List<ValidationMessageTransformation> validationMessageTransformations, String validFrom, String validTill, List<CreationDateLocator> creationDateLocators) {
        if (fhirPackage == null) {
            throw new NullPointerException("fhirPackage is marked non-null but is null");
        }
        this.fhirPackage = fhirPackage;
        this.dependencies = dependencies;
        this.validationMessageTransformations = validationMessageTransformations;
        this.validFrom = validFrom;
        this.validTill = validTill;
        this.creationDateLocators = creationDateLocators;
    }
}

