/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import lombok.NonNull;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.yaml.snakeyaml.Yaml;

public class Plugin {
    private static final String CONFIG_FILE = "config.yaml";
    private ZipFile zipFile;
    private Path pluginFolder;

    private Plugin(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    public Plugin(@NonNull Path pluginFolder) {
        if (pluginFolder == null) {
            throw new NullPointerException("pluginFolder is marked non-null but is null");
        }
        this.pluginFolder = pluginFolder;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getId() {
        try {
            String string;
            block12: {
                InputStream packagesConfigFile = this.getResource(CONFIG_FILE);
                try {
                    Yaml yaml = new Yaml();
                    Map document = (Map)yaml.load(packagesConfigFile);
                    string = document.get("id").toString();
                    if (packagesConfigFile == null) break block12;
                }
                catch (Throwable throwable) {
                    if (packagesConfigFile != null) {
                        try {
                            packagesConfigFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                packagesConfigFile.close();
            }
            return string;
        }
        finally {
            if (this.zipFile != null) {
                this.zipFile.close();
            }
        }
    }

    public static Plugin createFromZipFile(@NonNull ZipFile zipFile) {
        if (zipFile == null) {
            throw new NullPointerException("zipFile is marked non-null but is null");
        }
        return new Plugin(zipFile);
    }

    public static Plugin createFromFolder(@NonNull Path pluginFolder) {
        if (pluginFolder == null) {
            throw new NullPointerException("pluginFolder is marked non-null but is null");
        }
        return new Plugin(pluginFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getResource(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (this.zipFile != null) {
            try (FileInputStream is = new FileInputStream(this.zipFile.getName());
                 ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream((InputStream)is);){
                ZipArchiveEntry entry;
                do {
                    if ((entry = zipInputStream.getNextEntry()) == null) return null;
                } while (!entry.getName().contains(path));
                InputStream inputStream = this.createEntryInputStream(zipInputStream);
                return inputStream;
            }
            finally {
                this.zipFile.close();
            }
        }
        try (Stream<Path> filesStream = Files.walk(this.pluginFolder, new FileVisitOption[0]);){
            Optional<Path> file = filesStream.filter(p -> p.endsWith(path) && Files.isRegularFile(p, new LinkOption[0])).findFirst();
            if (file.isEmpty()) {
                InputStream inputStream = null;
                return inputStream;
            }
            InputStream inputStream = Files.newInputStream(file.get(), new OpenOption[0]);
            return inputStream;
        }
    }

    private InputStream createEntryInputStream(@NonNull ZipArchiveInputStream zipInputStream) throws IOException {
        int bytesRead;
        if (zipInputStream == null) {
            throw new NullPointerException("zipInputStream is marked non-null but is null");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = zipInputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, bytesRead);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

