/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv.plugins.validation;

import ca.uhn.fhir.context.FhirContext;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.gematik.refv.commons.Profile;
import de.gematik.refv.commons.configuration.DependencyList;
import de.gematik.refv.commons.configuration.ProfileConfiguration;
import de.gematik.refv.commons.configuration.SupportedProfileVersions;
import de.gematik.refv.commons.configuration.ValidationModuleConfiguration;
import de.gematik.refv.commons.validation.BaseValidationResourceProvider;
import de.gematik.refv.commons.validation.support.CustomNpmPackageValidationSupport;
import de.gematik.refv.plugins.configuration.MalformedPackageDeclarationException;
import de.gematik.refv.plugins.configuration.PluginDefinition;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginValidationResourceProvider
extends BaseValidationResourceProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginValidationResourceProvider.class);
    private static final String CONFIG_FILE = "config.yaml";
    private final Function<String, InputStream> resourceLoaderFunction;
    private final FhirContext fhirContext;
    private volatile ValidationModuleConfiguration cachedConfiguration;
    private final Object lockObject = new Object();

    public PluginValidationResourceProvider(Function<String, InputStream> resourceLoaderFunction, FhirContext fhirContext) {
        super(resourceLoaderFunction);
        this.resourceLoaderFunction = resourceLoaderFunction;
        this.fhirContext = fhirContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationModuleConfiguration getConfiguration() {
        if (this.cachedConfiguration == null) {
            Object object = this.lockObject;
            synchronized (object) {
                if (this.cachedConfiguration == null) {
                    PluginDefinition pluginDefinition;
                    ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                    try (InputStream pluginDefinitionFile = this.getResource(CONFIG_FILE);){
                        pluginDefinition = (PluginDefinition)mapper.readValue(pluginDefinitionFile, PluginDefinition.class);
                    }
                    this.cachedConfiguration = this.createValidationModuleConfiguration(pluginDefinition);
                }
            }
        }
        return this.cachedConfiguration;
    }

    private ValidationModuleConfiguration createValidationModuleConfiguration(PluginDefinition pluginDefinition) throws MalformedPackageDeclarationException, IOException {
        ValidationModuleConfiguration validationModuleConfiguration = new ValidationModuleConfiguration();
        validationModuleConfiguration.setId(pluginDefinition.getId());
        validationModuleConfiguration.setAcceptedEncodings(pluginDefinition.getValidation().getAcceptedEncodings());
        validationModuleConfiguration.setAnyExtensionsAllowed(pluginDefinition.getValidation().isAnyExtensionsAllowed());
        validationModuleConfiguration.setErrorOnUnknownProfile(pluginDefinition.getValidation().isErrorOnUnknownProfile());
        validationModuleConfiguration.setVersion(pluginDefinition.getVersion());
        validationModuleConfiguration.setIgnoredCodeSystems(pluginDefinition.getValidation().getIgnoredCodeSystems() != null ? pluginDefinition.getValidation().getIgnoredCodeSystems() : new ArrayList());
        validationModuleConfiguration.setIgnoredValueSets(pluginDefinition.getValidation().getIgnoredValueSets() != null ? pluginDefinition.getValidation().getIgnoredValueSets() : new ArrayList());
        validationModuleConfiguration.setAcceptedEncodings(new ArrayList());
        ArrayList<String> dependencies = new ArrayList<String>();
        dependencies.add(pluginDefinition.getValidationFhirPackageAsFilename());
        dependencies.addAll(pluginDefinition.getValidationDependenciesAsFilenames());
        List distinctDependencies = dependencies.stream().distinct().collect(Collectors.toList());
        HashMap<String, DependencyList> dependencyLists = new HashMap<String, DependencyList>();
        DependencyList dependencyList = new DependencyList("", "", distinctDependencies, pluginDefinition.getValidation().getValidationMessageTransformations());
        dependencyLists.put(pluginDefinition.getValidation().getFhirPackage(), dependencyList);
        validationModuleConfiguration.setDependencyLists(dependencyLists);
        validationModuleConfiguration.setSupportedProfiles(this.getSupportedProfiles(pluginDefinition.getValidation().getFhirPackage()));
        return validationModuleConfiguration;
    }

    private Map<String, SupportedProfileVersions> getSupportedProfiles(@NonNull String fhirPackageName) throws IOException {
        if (fhirPackageName == null) {
            throw new NullPointerException("fhirPackageName is marked non-null but is null");
        }
        CustomNpmPackageValidationSupport customNpmPackageValidationSupport = CustomNpmPackageValidationSupport.create((FhirContext)this.fhirContext, (String)(fhirPackageName.replace("#", "-") + ".tgz"), this.resourceLoaderFunction);
        Collection allProfiles = customNpmPackageValidationSupport.getAllProfiles();
        HashMap<String, SupportedProfileVersions> supportedProfiles = new HashMap<String, SupportedProfileVersions>();
        if (allProfiles != null) {
            for (Profile definition : allProfiles) {
                ProfileConfiguration profileConfiguration = new ProfileConfiguration(List.of(fhirPackageName), null);
                HashMap<String, ProfileConfiguration> profileVersions = new HashMap<String, ProfileConfiguration>();
                profileVersions.put(definition.getVersion(), profileConfiguration);
                SupportedProfileVersions supportedProfileVersions = new SupportedProfileVersions(profileVersions);
                supportedProfiles.put(definition.getBaseCanonical(), supportedProfileVersions);
            }
        }
        return supportedProfiles;
    }
}

