/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv;

import ca.uhn.fhir.context.FhirContext;
import de.gematik.refv.Plugin;
import de.gematik.refv.SupportedValidationModule;
import de.gematik.refv.commons.exceptions.ValidationModuleInitializationException;
import de.gematik.refv.commons.validation.BaseValidationModule;
import de.gematik.refv.commons.validation.GenericValidator;
import de.gematik.refv.commons.validation.IntegratedValidationModule;
import de.gematik.refv.commons.validation.IntegratedValidationResourceProvider;
import de.gematik.refv.commons.validation.ValidationModule;
import de.gematik.refv.commons.validation.ValidationModuleResourceProvider;
import de.gematik.refv.plugins.validation.PluginValidationResourceProvider;
import de.gematik.refv.valmodule.erpta7.ErpTa7ValidationModule;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationModuleFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidationModuleFactory.class);

    public ValidationModule createValidationModuleFromPlugin(@NonNull Plugin plugin) throws ValidationModuleInitializationException {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        FhirContext fhirContext = FhirContext.forR4();
        GenericValidator engine = new GenericValidator(fhirContext);
        BaseValidationModule result = new BaseValidationModule((ValidationModuleResourceProvider)new PluginValidationResourceProvider(plugin::getResource, fhirContext), engine);
        result.initialize();
        return result;
    }

    public ValidationModule createValidationModule(@NonNull SupportedValidationModule module) throws ValidationModuleInitializationException {
        ErpTa7ValidationModule result;
        if (module == null) {
            throw new NullPointerException("module is marked non-null but is null");
        }
        if (module == SupportedValidationModule.ERPTA7) {
            result = new ErpTa7ValidationModule((ValidationModuleResourceProvider)new IntegratedValidationResourceProvider("erpta7"));
        } else {
            GenericValidator engine = new GenericValidator(FhirContext.forR4());
            result = new IntegratedValidationModule(module.toString(), engine);
        }
        result.initialize();
        return result;
    }

    @Generated
    public ValidationModuleFactory() {
    }
}

