/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv.plugins.validation;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.gematik.refv.commons.configuration.DependencyList;
import de.gematik.refv.commons.configuration.ValidationModuleConfiguration;
import de.gematik.refv.commons.validation.BaseValidationResourceProvider;
import de.gematik.refv.plugins.configuration.MalformedPackageDeclarationException;
import de.gematik.refv.plugins.configuration.PluginDefinition;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginValidationResourceProvider
extends BaseValidationResourceProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginValidationResourceProvider.class);
    private static final String CONFIG_FILE = "config.yaml";

    public PluginValidationResourceProvider(Function<String, InputStream> resourceLoaderFunction) {
        super(resourceLoaderFunction);
    }

    public ValidationModuleConfiguration getConfiguration() {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        InputStream pluginDefinitionFile = this.getResource(CONFIG_FILE);
        PluginDefinition pluginDefinition = (PluginDefinition)mapper.readValue(pluginDefinitionFile, PluginDefinition.class);
        return this.createValidationModuleConfiguration(pluginDefinition);
    }

    private ValidationModuleConfiguration createValidationModuleConfiguration(PluginDefinition pluginDefinition) throws MalformedPackageDeclarationException {
        ValidationModuleConfiguration validationModuleConfiguration = new ValidationModuleConfiguration();
        validationModuleConfiguration.setId(pluginDefinition.getId());
        validationModuleConfiguration.setAcceptedEncodings(pluginDefinition.getValidation().getAcceptedEncodings());
        validationModuleConfiguration.setAnyExtensionsAllowed(pluginDefinition.getValidation().isAnyExtensionsAllowed());
        validationModuleConfiguration.setErrorOnUnknownProfile(pluginDefinition.getValidation().isErrorOnUnknownProfile());
        validationModuleConfiguration.setVersion(pluginDefinition.getVersion());
        validationModuleConfiguration.setIgnoredCodeSystems(pluginDefinition.getValidation().getIgnoredCodeSystems() != null ? pluginDefinition.getValidation().getIgnoredCodeSystems() : new ArrayList());
        validationModuleConfiguration.setIgnoredValueSets(pluginDefinition.getValidation().getIgnoredValueSets() != null ? pluginDefinition.getValidation().getIgnoredValueSets() : new ArrayList());
        validationModuleConfiguration.setAcceptedEncodings(new ArrayList());
        ArrayList<String> dependencies = new ArrayList<String>();
        dependencies.add(pluginDefinition.getValidationFhirPackageAsFilename());
        dependencies.addAll(pluginDefinition.getValidationDependenciesAsFilenames());
        List distinctDependencies = dependencies.stream().distinct().collect(Collectors.toList());
        HashMap<String, DependencyList> dependencyLists = new HashMap<String, DependencyList>();
        DependencyList dependencyList = new DependencyList("", "", distinctDependencies, pluginDefinition.getValidation().getValidationMessageTransformations());
        dependencyLists.put(pluginDefinition.getValidation().getFhirPackage(), dependencyList);
        validationModuleConfiguration.setDependencyLists(dependencyLists);
        return validationModuleConfiguration;
    }
}

