/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv.plugins.configuration;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.gematik.refv.plugins.configuration.MalformedPackageDeclarationException;
import de.gematik.refv.plugins.configuration.PluginDefinitionValidationSection;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PluginDefinition {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginDefinition.class);
    @NonNull
    private String configSpecVersion;
    @NonNull
    private String id;
    @NonNull
    private String version;
    @NonNull
    private String author;
    @NonNull
    private String description;
    private String specUrl;
    @NonNull
    private PluginDefinitionValidationSection validation;
    private List<String> snapshotDependencies = new LinkedList<String>();
    private static final String MALFORMED_PACKAGE_DECLARATION_TEXT = "Malformed package name '%s' (expected format: packageName#packageVersion)";
    private static final String PACKAGE_FILENAME_FORMATTER = "%s-%s.tgz";

    public String getValidationFhirPackageAsFilename() throws MalformedPackageDeclarationException {
        String validationFhirPackage = this.getValidation().getFhirPackage();
        String[] validationFhirPackageNameAndVersion = validationFhirPackage.split("#");
        if (validationFhirPackageNameAndVersion.length < 2) {
            throw new MalformedPackageDeclarationException(String.format(MALFORMED_PACKAGE_DECLARATION_TEXT, validationFhirPackage));
        }
        return String.format(PACKAGE_FILENAME_FORMATTER, validationFhirPackageNameAndVersion[0], validationFhirPackageNameAndVersion[1]);
    }

    public List<String> getValidationDependenciesAsFilenames() throws MalformedPackageDeclarationException {
        if (this.getValidation().getDependencies() != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (String s : this.getValidation().getDependencies()) {
                String[] split = s.split("#");
                if (split.length < 2) {
                    throw new MalformedPackageDeclarationException(String.format(MALFORMED_PACKAGE_DECLARATION_TEXT, s));
                }
                String filename = String.format(PACKAGE_FILENAME_FORMATTER, split[0], split[1]);
                result.add(filename);
            }
            return result;
        }
        return new ArrayList<String>();
    }

    @NonNull
    @Generated
    public String getConfigSpecVersion() {
        return this.configSpecVersion;
    }

    @NonNull
    @Generated
    public String getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getVersion() {
        return this.version;
    }

    @NonNull
    @Generated
    public String getAuthor() {
        return this.author;
    }

    @NonNull
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getSpecUrl() {
        return this.specUrl;
    }

    @NonNull
    @Generated
    public PluginDefinitionValidationSection getValidation() {
        return this.validation;
    }

    @Generated
    public List<String> getSnapshotDependencies() {
        return this.snapshotDependencies;
    }

    @Generated
    public void setConfigSpecVersion(@NonNull String configSpecVersion) {
        if (configSpecVersion == null) {
            throw new NullPointerException("configSpecVersion is marked non-null but is null");
        }
        this.configSpecVersion = configSpecVersion;
    }

    @Generated
    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @Generated
    public void setVersion(@NonNull String version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        this.version = version;
    }

    @Generated
    public void setAuthor(@NonNull String author) {
        if (author == null) {
            throw new NullPointerException("author is marked non-null but is null");
        }
        this.author = author;
    }

    @Generated
    public void setDescription(@NonNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.description = description;
    }

    @Generated
    public void setSpecUrl(String specUrl) {
        this.specUrl = specUrl;
    }

    @Generated
    public void setValidation(@NonNull PluginDefinitionValidationSection validation) {
        if (validation == null) {
            throw new NullPointerException("validation is marked non-null but is null");
        }
        this.validation = validation;
    }

    @Generated
    public void setSnapshotDependencies(List<String> snapshotDependencies) {
        this.snapshotDependencies = snapshotDependencies;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginDefinition)) {
            return false;
        }
        PluginDefinition other = (PluginDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$configSpecVersion = this.getConfigSpecVersion();
        String other$configSpecVersion = other.getConfigSpecVersion();
        if (this$configSpecVersion == null ? other$configSpecVersion != null : !this$configSpecVersion.equals(other$configSpecVersion)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$specUrl = this.getSpecUrl();
        String other$specUrl = other.getSpecUrl();
        if (this$specUrl == null ? other$specUrl != null : !this$specUrl.equals(other$specUrl)) {
            return false;
        }
        PluginDefinitionValidationSection this$validation = this.getValidation();
        PluginDefinitionValidationSection other$validation = other.getValidation();
        if (this$validation == null ? other$validation != null : !((Object)this$validation).equals(other$validation)) {
            return false;
        }
        List<String> this$snapshotDependencies = this.getSnapshotDependencies();
        List<String> other$snapshotDependencies = other.getSnapshotDependencies();
        return !(this$snapshotDependencies == null ? other$snapshotDependencies != null : !((Object)this$snapshotDependencies).equals(other$snapshotDependencies));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PluginDefinition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $configSpecVersion = this.getConfigSpecVersion();
        result = result * 59 + ($configSpecVersion == null ? 43 : $configSpecVersion.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $specUrl = this.getSpecUrl();
        result = result * 59 + ($specUrl == null ? 43 : $specUrl.hashCode());
        PluginDefinitionValidationSection $validation = this.getValidation();
        result = result * 59 + ($validation == null ? 43 : ((Object)$validation).hashCode());
        List<String> $snapshotDependencies = this.getSnapshotDependencies();
        result = result * 59 + ($snapshotDependencies == null ? 43 : ((Object)$snapshotDependencies).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PluginDefinition(configSpecVersion=" + this.getConfigSpecVersion() + ", id=" + this.getId() + ", version=" + this.getVersion() + ", author=" + this.getAuthor() + ", description=" + this.getDescription() + ", specUrl=" + this.getSpecUrl() + ", validation=" + this.getValidation() + ", snapshotDependencies=" + this.getSnapshotDependencies() + ")";
    }

    @ConstructorProperties(value={"configSpecVersion", "id", "version", "author", "description", "specUrl", "validation", "snapshotDependencies"})
    @Generated
    public PluginDefinition(@NonNull String configSpecVersion, @NonNull String id, @NonNull String version, @NonNull String author, @NonNull String description, String specUrl, @NonNull PluginDefinitionValidationSection validation, List<String> snapshotDependencies) {
        if (configSpecVersion == null) {
            throw new NullPointerException("configSpecVersion is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (author == null) {
            throw new NullPointerException("author is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (validation == null) {
            throw new NullPointerException("validation is marked non-null but is null");
        }
        this.configSpecVersion = configSpecVersion;
        this.id = id;
        this.version = version;
        this.author = author;
        this.description = description;
        this.specUrl = specUrl;
        this.validation = validation;
        this.snapshotDependencies = snapshotDependencies;
    }

    @Generated
    public PluginDefinition() {
    }
}

