/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv;

import ca.uhn.fhir.context.FhirContext;
import de.gematik.refv.SupportedValidationModule;
import de.gematik.refv.commons.ReferencedProfileLocator;
import de.gematik.refv.commons.configuration.FhirPackageConfigurationLoader;
import de.gematik.refv.commons.exceptions.ValidationModuleInitializationException;
import de.gematik.refv.commons.validation.GenericValidator;
import de.gematik.refv.commons.validation.GenericValidatorFactory;
import de.gematik.refv.commons.validation.ProfileCacheStrategy;
import de.gematik.refv.commons.validation.SeverityLevelTransformer;
import de.gematik.refv.commons.validation.ValidationModule;
import de.gematik.refv.valmodule.eau.EauValidationModule;
import de.gematik.refv.valmodule.erp.ErpValidationModule;
import lombok.Generated;
import lombok.NonNull;

public class ValidationModuleFactory {
    public ValidationModule createValidationModule(@NonNull SupportedValidationModule module) throws IllegalArgumentException, ValidationModuleInitializationException {
        ErpValidationModule result;
        if (module == null) {
            throw new NullPointerException("module is marked non-null but is null");
        }
        GenericValidator engine = new GenericValidator(FhirContext.forR4(), new ReferencedProfileLocator(), new GenericValidatorFactory(), new SeverityLevelTransformer(), ProfileCacheStrategy.CACHE_PROFILES);
        switch (module) {
            case ERP: {
                result = new ErpValidationModule(new FhirPackageConfigurationLoader(), engine);
                break;
            }
            case EAU: {
                result = new EauValidationModule(new FhirPackageConfigurationLoader(), engine);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported validation module: " + module);
            }
        }
        result.initialize();
        return result;
    }

    @Generated
    public ValidationModuleFactory() {
    }
}

