/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv;

import ca.uhn.fhir.context.FhirContext;
import de.gematik.refv.SupportedValidationModule;
import de.gematik.refv.commons.ReferencedProfileLocator;
import de.gematik.refv.commons.configuration.FhirPackageConfigurationLoader;
import de.gematik.refv.commons.exceptions.ValidationModuleInitializationException;
import de.gematik.refv.commons.validation.GenericValidator;
import de.gematik.refv.commons.validation.GenericValidatorFactory;
import de.gematik.refv.commons.validation.ProfileCacheStrategy;
import de.gematik.refv.commons.validation.SeverityLevelTransformer;
import de.gematik.refv.commons.validation.ValidationModule;
import de.gematik.refv.valmodule.erp.ErpValidationModule;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationModuleFactory {
    static Logger logger = LoggerFactory.getLogger(ValidationModuleFactory.class);

    public ValidationModule createValidationModule(@NonNull SupportedValidationModule module) throws IllegalArgumentException, ValidationModuleInitializationException {
        if (module == null) {
            throw new NullPointerException("module is marked non-null but is null");
        }
        if (!SupportedValidationModule.ERP.equals((Object)module)) {
            throw new IllegalArgumentException("Unsupported validation module: " + module);
        }
        GenericValidator engine = new GenericValidator(FhirContext.forR4(), new ReferencedProfileLocator(), new GenericValidatorFactory(), new SeverityLevelTransformer(), ProfileCacheStrategy.CACHE_PROFILES);
        ErpValidationModule erpValidationModule = new ErpValidationModule(new FhirPackageConfigurationLoader(), engine);
        erpValidationModule.initialize();
        return erpValidationModule;
    }

    @Generated
    public ValidationModuleFactory() {
    }
}

