/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv.valmodule.erpta7.helper;

import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import lombok.Generated;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class NonReachableEntriesChecker {
    private static final String RULE_BDL_7_MESSAGE = "Entry '%s' isn't reachable by traversing links (forward or backward) from the Composition";
    private static final String RULE_BDL_7_CODE = "Bundle_BUNDLE_Entry_Orphan_DOCUMENT";
    private final XPathFactory xPathFactory = XPathFactory.newInstance();

    public List<SingleValidationMessage> checkForNonReachableEntries(Document resource) {
        if (!this.isDocumentType(resource)) {
            return new LinkedList<SingleValidationMessage>();
        }
        LinkedList<SingleValidationMessage> result = new LinkedList<SingleValidationMessage>();
        String[] allFullUrls = this.getAllFullUrls(resource);
        String[] referencedEntries = this.getEntriesReferencedInComposition(resource);
        Arrays.stream(allFullUrls).filter(fullUrl -> Arrays.stream(referencedEntries).noneMatch(fullUrl::endsWith)).forEach(fullUrl -> {
            SingleValidationMessage validationMessage = new SingleValidationMessage();
            validationMessage.setMessage(String.format(RULE_BDL_7_MESSAGE, fullUrl));
            validationMessage.setSeverity(ResultSeverityEnum.ERROR);
            validationMessage.setMessageId(RULE_BDL_7_CODE);
            result.add(validationMessage);
        });
        return result;
    }

    private boolean isDocumentType(Document resource) {
        XPath xPath = this.xPathFactory.newXPath();
        XPathExpression exp = xPath.compile("/Bundle/type/@value");
        return "document".equals(exp.evaluate(resource, XPathConstants.STRING));
    }

    private String[] getEntriesReferencedInComposition(Document resource) {
        XPath xPath = this.xPathFactory.newXPath();
        XPathExpression exp = xPath.compile("/Bundle/entry/resource/Composition/section/entry/reference/@value");
        NodeList references = (NodeList)exp.evaluate(resource, XPathConstants.NODESET);
        String[] result = new String[references.getLength()];
        for (int i = 0; i < references.getLength(); ++i) {
            result[i] = references.item(i).getNodeValue();
        }
        return result;
    }

    private String[] getAllFullUrls(Document resource) {
        XPath xPath = this.xPathFactory.newXPath();
        XPathExpression exp = xPath.compile("/Bundle/entry[not(self::entry/resource/Composition)]/fullUrl/@value");
        NodeList fullUrls = (NodeList)exp.evaluate(resource, XPathConstants.NODESET);
        String[] result = new String[fullUrls.getLength()];
        for (int i = 0; i < fullUrls.getLength(); ++i) {
            result[i] = fullUrls.item(i).getNodeValue();
        }
        return result;
    }

    @Generated
    public NonReachableEntriesChecker() {
    }
}

