/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv.valmodule.erpta7.helper;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.XmlParser;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class BundleReducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BundleReducer.class);
    private final DocumentBuilder documentBuilder;
    private final XPathFactory xPathFactory = XPathFactory.newInstance();
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private final Document document;
    private final XmlParser xmlParser = (XmlParser)FhirContext.forR4().newXmlParser();

    public BundleReducer(String resourceBody) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = this.documentBuilder.parse(new InputSource(new StringReader(resourceBody)));
    }

    public BundleReducer(Document document) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = document;
    }

    public List<String> getAllRezeptBundlesAsString() throws XPathExpressionException, TransformerException {
        ArrayList<String> allEntriesAsStrings = new ArrayList<String>();
        XPath xpath = this.xPathFactory.newXPath();
        NodeList resources = (NodeList)xpath.compile("/Bundle/entry/resource/Bundle").evaluate(this.document, XPathConstants.NODESET);
        for (int i = 0; i < resources.getLength(); ++i) {
            Node resource = resources.item(i);
            Element rootElement = (Element)resource;
            rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://hl7.org/fhir");
            allEntriesAsStrings.add(this.serializeToString(rootElement));
        }
        return allEntriesAsStrings;
    }

    public String getReducedResourceBody() throws XPathExpressionException, TransformerException {
        NodeList fixedChildren = this.getFixedChildren(this.document);
        NodeList entries = this.getEntries(this.document);
        Document newDoc = this.documentBuilder.newDocument();
        Element rootElement = newDoc.createElementNS("http://hl7.org/fhir", "Bundle");
        newDoc.appendChild(rootElement);
        XPath xPath = this.xPathFactory.newXPath();
        XPathExpression compositionExpression = xPath.compile("resource/Composition");
        NodeList compositionNodes = (NodeList)compositionExpression.evaluate(entries.item(0), XPathConstants.NODESET);
        if (compositionNodes.getLength() == 0) {
            Node importedNode = newDoc.importNode(entries.item(0), true);
            rootElement.appendChild(importedNode);
            this.copyFixedChildren(newDoc, rootElement, fixedChildren);
        } else {
            this.copyFixedChildren(newDoc, rootElement, fixedChildren);
            this.copyFirstRezeptBundle(newDoc, rootElement, entries);
        }
        String reducedBodyAsString = this.serializeToString(newDoc);
        return this.removeDangledReferencesFromComposition(reducedBodyAsString);
    }

    private String removeDangledReferencesFromComposition(String reducedBodyAsString) {
        Bundle bundle = (Bundle)this.xmlParser.parseResource(Bundle.class, reducedBodyAsString);
        Optional<Bundle.BundleEntryComponent> compositionOptional = bundle.getEntry().stream().filter(e -> e.getResource().hasType(new String[]{"Composition"})).findFirst();
        if (compositionOptional.isEmpty()) {
            log.warn("Could not find composition in reduced bundle");
            return reducedBodyAsString;
        }
        List allFullUrls = bundle.getEntry().stream().map(Bundle.BundleEntryComponent::getFullUrl).collect(Collectors.toList());
        Composition c = (Composition)compositionOptional.get().getResource();
        List sectionsWithRechnungBundles = c.getSection().stream().filter(BundleReducer::isSectionWithReferenceToRechnungBundle).collect(Collectors.toList());
        sectionsWithRechnungBundles.stream().filter(s -> BundleReducer.isSectionReferenceMissingInReducedBundle(s, allFullUrls)).forEach(s -> c.getSection().remove(s));
        return this.xmlParser.encodeResourceToString((IBaseResource)bundle);
    }

    private static boolean isSectionReferenceMissingInReducedBundle(Composition.SectionComponent s, List<String> allFullUrls) {
        return !allFullUrls.contains(((Reference)s.getEntry().get(0)).getReference());
    }

    private static boolean isSectionWithReferenceToRechnungBundle(Composition.SectionComponent s) {
        return !s.getEntry().isEmpty() && s.getCode().hasCoding("https://fhir.gkvsv.de/CodeSystem/GKVSV_CS_ERP_TA7", "RB");
    }

    private NodeList getFixedChildren(Document doc) throws XPathExpressionException {
        XPath xpath = this.xPathFactory.newXPath();
        XPathExpression expr = xpath.compile("/Bundle/*[not(self::entry/resource/Bundle)]");
        return (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
    }

    private NodeList getEntries(Document doc) throws XPathExpressionException {
        XPath xpath = this.xPathFactory.newXPath();
        return (NodeList)xpath.compile("/Bundle/entry").evaluate(doc, XPathConstants.NODESET);
    }

    private void copyFixedChildren(Document newDoc, Element rootElement, NodeList fixedChildren) {
        for (int i = 0; i < fixedChildren.getLength(); ++i) {
            Node fixedNode = fixedChildren.item(i);
            Node importedNode = newDoc.importNode(fixedNode, true);
            rootElement.appendChild(importedNode);
        }
    }

    private void copyFirstRezeptBundle(Document newDoc, Element rootElement, NodeList entries) throws XPathExpressionException {
        XPath xPath = this.xPathFactory.newXPath();
        XPathExpression bundleExpression = xPath.compile("resource/Bundle");
        for (int i = 0; i < entries.getLength(); ++i) {
            Node entryNode = entries.item(i);
            NodeList bundleNodes = (NodeList)bundleExpression.evaluate(entryNode, XPathConstants.NODESET);
            if (bundleNodes.getLength() <= 0) continue;
            Node importedNode = newDoc.importNode(entryNode, true);
            rootElement.appendChild(importedNode);
            break;
        }
    }

    private String serializeToString(Node newDoc) throws TransformerException {
        StringWriter sw = new StringWriter();
        Transformer transformer = this.transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(newDoc), new StreamResult(sw));
        return sw.toString();
    }
}

