/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv.valmodule.erpta7;

import de.gematik.refv.commons.Profile;
import de.gematik.refv.commons.configuration.ValidationModuleConfiguration;
import de.gematik.refv.commons.exceptions.ValidationModuleInitializationException;
import de.gematik.refv.commons.validation.ReferencedProfileLocator;
import de.gematik.refv.commons.validation.ValidationModule;
import de.gematik.refv.commons.validation.ValidationModuleResourceProvider;
import de.gematik.refv.commons.validation.ValidationOptions;
import de.gematik.refv.commons.validation.ValidationResult;
import de.gematik.refv.valmodule.erpta7.ErpTa7RechnungBundleValidator;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErpTa7ValidationModule
implements ValidationModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErpTa7ValidationModule.class);
    public static final String RECHNUNG_BUNDLE = "https://fhir.gkvsv.de/StructureDefinition/GKVSV_PR_TA7_Rechnung_Bundle";
    private final ValidationModuleResourceProvider resourceProvider;
    private final ErpTa7RechnungBundleValidator erpTa7RechnungBundleValidator = new ErpTa7RechnungBundleValidator();
    private final ReferencedProfileLocator referencedProfileLocator = new ReferencedProfileLocator();
    private String code;
    private ValidationModuleConfiguration configuration;

    public String getId() {
        return this.code;
    }

    public ValidationModuleConfiguration getConfiguration() {
        return this.configuration;
    }

    public ErpTa7ValidationModule(@NonNull ValidationModuleResourceProvider resourceProvider) {
        if (resourceProvider == null) {
            throw new NullPointerException("resourceProvider is marked non-null but is null");
        }
        this.resourceProvider = resourceProvider;
    }

    public void initialize() throws ValidationModuleInitializationException {
        try {
            this.configuration = this.resourceProvider.getConfiguration();
            this.code = this.configuration.getId();
        }
        catch (Exception e) {
            throw new ValidationModuleInitializationException("Initialization failed", (Throwable)e);
        }
    }

    public ValidationResult validateFile(@NonNull String inputFile, ValidationOptions validationOptions) throws IllegalArgumentException, IOException {
        if (inputFile == null) {
            throw new NullPointerException("inputFile is marked non-null but is null");
        }
        return this.validateFile(Path.of(inputFile, new String[0]), validationOptions);
    }

    public ValidationResult validateString(String fhirResourceAsString, ValidationOptions validationOptions) {
        List allProfiles = this.referencedProfileLocator.getAllReferencedProfilesInResource(fhirResourceAsString);
        if (allProfiles.isEmpty()) {
            throw new IllegalArgumentException("FHIR resources without a referenced profile are currently unsupported");
        }
        Profile profileInResource = this.configuration.findFirstSupportedProfileWithExistingConfiguration(allProfiles);
        if (profileInResource == null) {
            throw new IllegalArgumentException(String.format("The erpta7 validation module should only be used to validate %s resources", RECHNUNG_BUNDLE));
        }
        ValidationResult result = this.erpTa7RechnungBundleValidator.validateBundleConcurrently(fhirResourceAsString, validationOptions);
        log.debug("ValidationResult: {}", (Object)result);
        return result;
    }

    public ValidationResult validateFile(Path inputPath, ValidationOptions validationOptions) throws IllegalArgumentException, IOException {
        log.info("Reading input file {}...", (Object)inputPath);
        String body = Files.readString(inputPath, StandardCharsets.UTF_8);
        return this.validateString(body, validationOptions);
    }

    public ValidationResult validateFile(@NonNull String inputFile) throws IllegalArgumentException, IOException {
        if (inputFile == null) {
            throw new NullPointerException("inputFile is marked non-null but is null");
        }
        return this.validateFile(inputFile, ValidationOptions.getDefaults());
    }

    public ValidationResult validateString(@NonNull String fhirResourceAsString) throws IllegalArgumentException {
        if (fhirResourceAsString == null) {
            throw new NullPointerException("fhirResourceAsString is marked non-null but is null");
        }
        return this.validateString(fhirResourceAsString, ValidationOptions.getDefaults());
    }

    public ValidationResult validateFile(@NonNull Path inputPath) throws IllegalArgumentException, IOException {
        if (inputPath == null) {
            throw new NullPointerException("inputPath is marked non-null but is null");
        }
        return this.validateFile(inputPath, ValidationOptions.getDefaults());
    }
}

