/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv.valmodule.erpta7.helper;

import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;

public class DuplicateChecker {
    private static final String RULE_BDL_7_MESSAGE = "'FullUrl must be unique in a bundle, or else entries with the same fullUrl must have different meta.versionId (except in history bundles)' Failed for fullUrl: ";
    private static final String RULE_BDL_7_CODE = "Rule bdl-7";

    public List<SingleValidationMessage> findDuplicateFullUrls(String resourceBody) {
        String[] allFullUrls = this.getAllFullUrls(resourceBody);
        LinkedList<SingleValidationMessage> result = new LinkedList<SingleValidationMessage>();
        for (int i = 0; i < allFullUrls.length - 1; ++i) {
            if (!allFullUrls[i].equals(allFullUrls[i + 1])) continue;
            SingleValidationMessage validationMessage = new SingleValidationMessage();
            validationMessage.setMessage(RULE_BDL_7_MESSAGE + allFullUrls[i]);
            validationMessage.setSeverity(ResultSeverityEnum.ERROR);
            validationMessage.setMessageId(RULE_BDL_7_CODE);
            result.add(validationMessage);
        }
        return result;
    }

    private String[] getAllFullUrls(String resourceBody) {
        Pattern pattern = Pattern.compile("<entry>\\s*<fullUrl value=\"([^\"]+)\"", 32);
        return (String[])pattern.matcher(resourceBody).results().map(r -> r.group(1)).sorted().toArray(String[]::new);
    }

    @Generated
    public DuplicateChecker() {
    }
}

