/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv.valmodule.erpta7;

import ca.uhn.fhir.context.FhirContext;
import de.gematik.refv.commons.validation.GenericValidator;
import de.gematik.refv.commons.validation.IntegratedValidationModule;
import de.gematik.refv.commons.validation.ValidationModule;
import de.gematik.refv.commons.validation.ValidationOptions;
import de.gematik.refv.commons.validation.ValidationResult;
import de.gematik.refv.valmodule.erpta7.helper.BundleReducer;
import de.gematik.refv.valmodule.erpta7.helper.DuplicateChecker;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErpTa7RechnungBundleValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErpTa7RechnungBundleValidator.class);
    private final DuplicateChecker duplicateChecker = new DuplicateChecker();
    private static final int THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    private final ValidationModule validator = this.getErpValidationModule();

    public ValidationResult validateBundleConcurrently(String resourceBody, ValidationOptions options) {
        BundleReducer bundleReducer = new BundleReducer(resourceBody);
        String reducedResourceBody = bundleReducer.getReducedResourceBody();
        log.debug("Extracting GKVSV_PR_TA7_RezeptBundle entries...");
        List<String> allRezeptBundlesAsString = bundleReducer.getAllRezeptBundlesAsString();
        log.debug("Validating reduced TA7-Bundle...");
        ValidationResult result = this.validator.validateString(reducedResourceBody, options);
        this.performConcurrentValidation(allRezeptBundlesAsString, result, options);
        log.debug("Checking for duplicate fullURLs...");
        result.getValidationMessages().addAll(this.duplicateChecker.findDuplicateFullUrls(resourceBody));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performConcurrentValidation(List<String> allEntriesAsStrings, ValidationResult result, ValidationOptions options) {
        ExecutorService executor = Executors.newFixedThreadPool(THREAD_POOL_SIZE);
        ArrayList<Future<ValidationResult>> futures = new ArrayList<Future<ValidationResult>>();
        for (String string : allEntriesAsStrings) {
            log.debug("Validating GKVSV_PR_TA7_RezeptBundle #{}...", (Object)(futures.size() + 1));
            Callable<ValidationResult> task = () -> this.validator.validateString(entryString, options);
            Future<ValidationResult> future = executor.submit(task);
            futures.add(future);
        }
        for (Future future : futures) {
            try {
                ValidationResult futureResult = (ValidationResult)future.get();
                result.getValidationMessages().addAll(futureResult.getValidationMessages());
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Error occurred while waiting for task to complete: {}", (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
        try {
            executor.shutdown();
            boolean terminated = executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            if (!terminated) {
                log.error("ExecutorService did not terminate within the specified time frame");
            }
        }
        catch (InterruptedException e) {
            log.error("Error occurred while waiting for all tasks to complete: {}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
        finally {
            executor.shutdownNow();
        }
    }

    private ValidationModule getErpValidationModule() {
        GenericValidator engine = new GenericValidator(FhirContext.forR4());
        return new IntegratedValidationModule("erp", engine);
    }
}

