/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv.valmodule.erpta7.helper;

import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class DuplicateChecker {
    private static final String RULE_BDL_7_MESSAGE = "'FullUrl must be unique in a bundle, or else entries with the same fullUrl must have different meta.versionId (except in history bundles)' Failed for fullUrl: ";
    private static final String RULE_BBUNDLE_MULTIPLE_MATCHES_MESSAGE = "Multiple matches in bundle for reference: ";
    private static final String RULE_BDL_7_CODE = "Rule bdl-7";
    private static final String RULE_BBUNDLE_MULTIPLE_MATCHES_CODE = "Bundle_BUNDLE_MultipleMatches";

    public List<SingleValidationMessage> findDuplicateFullUrls(String resourceBody) {
        HashSet<String> uniqueFullUrls = new HashSet<String>();
        HashSet<String> duplicateFullUrls = new HashSet<String>();
        List<String> allFullUrls = this.getAllFullUrls(resourceBody);
        for (String fullUrl : allFullUrls) {
            if (uniqueFullUrls.add(fullUrl)) continue;
            duplicateFullUrls.add(fullUrl);
        }
        LinkedList<SingleValidationMessage> result = new LinkedList<SingleValidationMessage>();
        for (String fullUrl : duplicateFullUrls) {
            result.add(this.getValidationMessage(RULE_BDL_7_MESSAGE, RULE_BDL_7_CODE, fullUrl));
        }
        return result;
    }

    public List<SingleValidationMessage> findDuplicateCompositionReferences(String resourceBody) {
        List<String> allFullUrls = this.getAllFullUrls(resourceBody);
        Pattern pattern = Pattern.compile("<entry>\\s*<reference value=\"(.*?)\"/>\\s*</entry>", 32);
        Matcher matcher = pattern.matcher(resourceBody);
        ArrayList<String> compositionReferences = new ArrayList<String>();
        while (matcher.find()) {
            String match = matcher.group(1);
            compositionReferences.add(match);
        }
        LinkedList<SingleValidationMessage> result = new LinkedList<SingleValidationMessage>();
        for (String compositionReference : compositionReferences) {
            int count = 0;
            for (String fullUrl : allFullUrls) {
                if (!compositionReference.equals(fullUrl)) continue;
                ++count;
            }
            if (count <= true) continue;
            result.add(this.getValidationMessage(RULE_BBUNDLE_MULTIPLE_MATCHES_MESSAGE, RULE_BBUNDLE_MULTIPLE_MATCHES_CODE, compositionReference));
        }
        return result;
    }

    private SingleValidationMessage getValidationMessage(String message, String messageId, String fullUrl) {
        SingleValidationMessage validationMessage = new SingleValidationMessage();
        validationMessage.setMessage(message + fullUrl);
        validationMessage.setSeverity(ResultSeverityEnum.ERROR);
        validationMessage.setMessageId(messageId);
        return validationMessage;
    }

    private List<String> getAllFullUrls(String resourceBody) {
        ArrayList<String> allFullUrls = new ArrayList<String>();
        Pattern pattern = Pattern.compile("<entry>\\s*<fullUrl value=\"(.*?)\"/>", 32);
        Matcher matcher = pattern.matcher(resourceBody);
        while (matcher.find()) {
            String match = matcher.group(1);
            allFullUrls.add(match);
        }
        return allFullUrls;
    }

    @Generated
    public DuplicateChecker() {
    }
}

