/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.refv.valmodule.erpta7.helper;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class BundleReducer {
    private final DocumentBuilder documentBuilder;
    private final XPathFactory xPathFactory;
    private final TransformerFactory transformerFactory;
    private final Document document;

    public BundleReducer(String resourceBody) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.xPathFactory = XPathFactory.newInstance();
        this.transformerFactory = TransformerFactory.newInstance();
        this.document = this.documentBuilder.parse(new InputSource(new StringReader(resourceBody)));
    }

    public List<String> getAllRezeptBundlesAsString() throws XPathExpressionException, TransformerException {
        ArrayList<String> allEntriesAsStrings = new ArrayList<String>();
        XPath xpath = this.xPathFactory.newXPath();
        NodeList resources = (NodeList)xpath.compile("/Bundle/entry/resource/Bundle").evaluate(this.document, XPathConstants.NODESET);
        for (int i = 0; i < resources.getLength(); ++i) {
            Node resource = resources.item(i);
            Element rootElement = (Element)resource;
            rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://hl7.org/fhir");
            allEntriesAsStrings.add(this.serializeToString(rootElement));
        }
        return allEntriesAsStrings;
    }

    public String getReducedResourceBody() throws XPathExpressionException, TransformerException {
        NodeList fixedChildren = this.getFixedChildren(this.document);
        NodeList entries = this.getEntries(this.document);
        Document newDoc = this.documentBuilder.newDocument();
        Element rootElement = newDoc.createElementNS("http://hl7.org/fhir", "Bundle");
        newDoc.appendChild(rootElement);
        this.copyFixedChildren(newDoc, rootElement, fixedChildren);
        this.copyFirstRezeptBundle(newDoc, rootElement, entries);
        return this.serializeToString(newDoc);
    }

    private NodeList getFixedChildren(Document doc) throws XPathExpressionException {
        XPath xpath = this.xPathFactory.newXPath();
        XPathExpression expr = xpath.compile("/Bundle/*[not(self::entry/resource/Bundle)]");
        return (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
    }

    private NodeList getEntries(Document doc) throws XPathExpressionException {
        XPath xpath = this.xPathFactory.newXPath();
        return (NodeList)xpath.compile("/Bundle/entry").evaluate(doc, XPathConstants.NODESET);
    }

    private void copyFixedChildren(Document newDoc, Element rootElement, NodeList fixedChildren) {
        for (int i = 0; i < fixedChildren.getLength(); ++i) {
            Node fixedNode = fixedChildren.item(i);
            Node importedNode = newDoc.importNode(fixedNode, true);
            rootElement.appendChild(importedNode);
        }
    }

    private void copyFirstRezeptBundle(Document newDoc, Element rootElement, NodeList entries) throws XPathExpressionException {
        XPath xPath = this.xPathFactory.newXPath();
        XPathExpression bundleExpression = xPath.compile("resource/Bundle");
        for (int i = 0; i < entries.getLength(); ++i) {
            Node entryNode = entries.item(i);
            NodeList bundleNodes = (NodeList)bundleExpression.evaluate(entryNode, XPathConstants.NODESET);
            if (bundleNodes.getLength() <= 0) continue;
            Node importedNode = newDoc.importNode(entryNode, true);
            rootElement.appendChild(importedNode);
            break;
        }
    }

    private String serializeToString(Node newDoc) throws TransformerException {
        StringWriter sw = new StringWriter();
        Transformer transformer = this.transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(newDoc), new StreamResult(sw));
        return sw.toString();
    }
}

