/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.sigtran;

import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.ProtocolSuite;
import org.jnetpcap.protocol.sigtran.SctpChunk;

@Header(description="Payload Data", suite=ProtocolSuite.SIGTRAN, nicname="Sctp-data")
public class SctpData
extends SctpChunk {
    public static final int ID = 33;
    public static final int CHUNK_DATA_UNORDERED_FLAG = 4;
    public static final int CHUNK_DATA_BEGINNING_FRAGMENT_FLAG = 2;
    public static final int CHUNK_DATA_ENDING_FRAMGNET_FLAG = 1;

    @Field(parent="flags", display=" B: Beginnning fragment", offset=1, length=1)
    public int flags_B() {
        return (this.flags() & 2) >> 1;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String flags_BDescription() {
        switch (this.flags_B()) {
            case 0: {
                return "no";
            }
            case 1: {
                return "yes";
            }
        }
        return "unknown option";
    }

    @Field(parent="flags", display="BE: Fragmentation", offset=0, length=2)
    public int flags_BE() {
        return (this.flags() & 3) >> 0;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String flags_BEDescription() {
        switch (this.flags_BE()) {
            case 0: {
                return "Middle piece of a fragmented user message";
            }
            case 1: {
                return "Last piece of a fragmented user message";
            }
            case 2: {
                return "First piece of a fragmented user message";
            }
            case 3: {
                return "Unfragmented message";
            }
        }
        return "unknown option";
    }

    @Field(parent="flags", display=" E: Ending fragment", offset=0, length=1)
    public int flags_E() {
        return (this.flags() & 1) >> 0;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String flags_EDescription() {
        switch (this.flags_E()) {
            case 0: {
                return "no";
            }
            case 1: {
                return "yes";
            }
        }
        return "unknown option";
    }

    @Field(parent="flags", display=" U: Data ordering", offset=2, length=1)
    public int flags_U() {
        return (this.flags() & 4) >> 2;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String flags_UDescription() {
        switch (this.flags_U()) {
            case 0: {
                return "ordered";
            }
            case 1: {
                return "unordered";
            }
        }
        return "unknown option";
    }

    @Field(offset=96, length=32, format="%d")
    public long protocol() {
        return super.getUInt(12);
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String protocolDescription() {
        return this.protocol() == 0L ? "not specified" : SctpDataProtocol.valueOf((int)this.protocol());
    }

    @Field(offset=64, length=16, format="%d")
    public int streamId() {
        return super.getUShort(8);
    }

    @Field(offset=80, length=16, format="%d")
    public int streamSequence() {
        return super.getUShort(10);
    }

    @Field(offset=32, length=32, format="%x")
    public long tsn() {
        return super.getUInt(4);
    }

    public void tsn(long l) {
        super.setUInt(4, l);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SctpDataProtocol {
        RESERVED1,
        IUA,
        M2UA,
        M3UA,
        SUA,
        M2PA,
        V5UA,
        H248,
        BICC_Q21503,
        TALI,
        DUA,
        ASAP,
        ENRP,
        H323,
        QIPC_Q21503,
        SIMCO,
        DDP_SEGMENT,
        DDP_STREAM,
        S1_APPLICATION,
        RUA,
        HNBAP,
        FORCES_HP,
        FORCES_MP,
        FORCES_LP,
        SBC_AP,
        NBAP,
        RESERVED2,
        X2AP,
        IRCP,
        LCS_AP,
        MPICH2,
        SABP,
        FGP,
        PPP,
        CALCAPP,
        SSP,
        NPMP_CONTROL,
        NPMP_DATA,
        ECHO,
        DISCARD,
        DAYTIME,
        CHARGEN,
        RNA_3GPP,
        M2AP_3GPP,
        SSH,
        DIAMETER_DATA,
        DIAMETER_DTLS;


        public static String valueOf(int n) {
            if (n < SctpDataProtocol.values().length) {
                return SctpDataProtocol.values()[n].toString();
            }
            return "Unassigned";
        }
    }
}

