/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.lan;

import java.nio.ByteOrder;
import org.jnetpcap.PcapDLT;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.util.checksum.Checksum;

@Header(length=14, dlt={PcapDLT.IEEE802})
public class IEEE802dot3
extends JHeader {
    public static final int ID = 6;

    @Field(offset=0, length=48, format="#mac#")
    public byte[] destination() {
        return this.getByteArray(0, 6);
    }

    public byte[] destinationToByteArray(byte[] byArray) {
        return this.getByteArray(0, byArray);
    }

    public void destination(byte[] byArray) {
        this.setByteArray(0, byArray);
    }

    @Field(offset=48, length=48, format="#mac#")
    public byte[] source() {
        return this.getByteArray(6, 6);
    }

    public void source(byte[] byArray) {
        this.setByteArray(6, byArray);
    }

    public byte[] sourceToByteArray(byte[] byArray) {
        return this.getByteArray(6, byArray);
    }

    @Field(offset=96, length=16, format="%d")
    public int length() {
        return this.getUShort(12);
    }

    public void length(int n) {
        this.setUShort(12, n);
    }

    @Dynamic(field="checksum", value=Field.Property.CHECK)
    public boolean checksumCheck() {
        return this.getPostfixLength() >= 4;
    }

    @Dynamic(value=Field.Property.OFFSET)
    public int checksumOffset() {
        return this.getPostfixOffset() * 8;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String checksumDescription() {
        long l = this.calculateChecksum();
        if (this.checksum() == l) {
            return "correct";
        }
        return "incorrect: 0x" + Long.toHexString(l).toUpperCase();
    }

    @Field(length=32, format="%x", display="FCS")
    public long checksum() {
        JPacket jPacket = this.getPacket();
        jPacket.order(ByteOrder.BIG_ENDIAN);
        return jPacket.getUInt(this.getPostfixOffset());
    }

    public long calculateChecksum() {
        if (this.getPostfixLength() < 4) {
            return 0L;
        }
        JPacket jPacket = this.getPacket();
        return Checksum.crc32IEEE802(jPacket, 0, jPacket.size() - 4);
    }
}

