/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol;

import java.io.File;
import java.io.PrintStream;
import junit.framework.TestCase;
import org.jnetpcap.packet.AbstractMessageHeader;
import org.jnetpcap.packet.JMemoryPacket;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.TestUtils;
import org.jnetpcap.packet.format.FormatUtils;
import org.jnetpcap.protocol.lan.SLL;
import org.jnetpcap.protocol.voip.Sip;
import org.junit.Test;

public class TestSip
extends TestCase {
    private static final PrintStream out = TestUtils.DISCARD;
    private final Sip sip = new Sip();

    @Test
    public void testSipINFO() {
        byte[] byArray = FormatUtils.toByteArray("000400010006000c2992d69a00000800450004b700004000401153470a1e679e0a1e671513c413c404a3e7a3494e464f207369703a6d736d6c4031302e33302e3130332e32313a35303630205349502f322e300d0a436f6e74656e742d4c656e6774683a203736390d0a546f3a203c7369703a6d736d6c4031302e33302e3130332e32313a353036303e3b7461673d31302e33302e3130332e3231353036302b312b66633335303031312b63653864616533650d0a436f6e746163743a203c7369703a31302e33302e3130332e3135383a353036303b7472616e73706f72743d5544503e0d0a435365713a203220494e464f0d0a5669613a205349502f322e302f5544502031302e33302e3130332e3135383a353036303b6272616e63683d7a39684734624b6e4a53344735446278517970324a72735a34464a4f310d0a43616c6c2d49443a2064444177575439546a440d0a436f6e74656e742d547970653a206170706c69636174696f6e2f6d736d6c2b786d6c0d0a46726f6d3a202276666c6970736c656532223c7369703a76666c6970736c6565324031302e33302e302e3135353e3b7461673d313231333538333031333430323934353733393836312e300d0a0d0a3c3f786d6c2076657273696f6e3d27312e302720656e636f64696e673d2755532d4153434949273f3e3c6d736d6c2076657273696f6e3d27312e31273e3c6469616c6f677374617274207461726765743d27636f6e6e3a31302e33302e3130332e3231353036302b312b66633335303031312b63653864616533652720747970653d276170706c69636174696f6e2f6d6f6d6c2b786d6c27206e616d653d27656e74657270696e416e6e6327203e3c706c6179206376643a62617267653d277472756527206376643a636c65617264623d2766616c736527203e3c617564696f207572693d2766696c653a2f2f6d6e742f31302e33302e3130322e3131362f62742f4d4d322f656e672f70696e5f70726f6d70742e77617627202f3e3c706c6179657869743e3c65786974206e616d656c6973743d27706c61792e656e64272f3e3c2f706c6179657869743e3c2f706c61793e3c2f6469616c6f6773746172743e3c6469616c6f677374617274207461726765743d27636f6e6e3a31302e33302e3130332e3231353036302b312b66633335303031312b63653864616533652720747970653d276170706c69636174696f6e2f6d6f6d6c2b786d6c27206e616d653d27656e74657270696e44746d6627203e3c64746d66206664743d2732307327206964743d2731307327206564743d2735732720636c65617264623d2766616c736527203e3c7061747465726e206469676974733d276d696e3d313b6d61783d32383b72746b3d232720666f726d61743d276d6f6d6c2b646967697473273e3c65786974206e616d656c6973743d2764746d662e6469676974732064746d662e656e64272f3e3c2f7061747465726e3e3c6e6f696e7075743e3c65786974206e616d656c6973743d2764746d662e6469676974732064746d662e656e64272f3e3c2f6e6f696e7075743e3c6e6f6d617463683e3c65786974206e616d656c6973743d2764746d662e6469676974732064746d662e656e64272f3e3c2f6e6f6d617463683e3c2f64746d663e3c2f6469616c6f6773746172743e3c2f6d736d6c3e");
        JMemoryPacket jMemoryPacket = new JMemoryPacket(SLL.ID, byArray);
        out.println(jMemoryPacket.getState().toDebugString());
        out.println(jMemoryPacket);
        TestCase.assertTrue((boolean)jMemoryPacket.hasHeader(this.sip));
        TestCase.assertEquals((Object)((Object)AbstractMessageHeader.MessageType.REQUEST), (Object)((Object)this.sip.getMessageType()));
        TestCase.assertTrue((boolean)this.sip.hasField(Sip.Request.RequestMethod));
        TestCase.assertEquals((String)"INFO", (String)this.sip.fieldValue(Sip.Request.RequestMethod));
        TestCase.assertEquals((Object)((Object)Sip.Method.INFO), (Object)((Object)this.sip.getMethod()));
        TestCase.assertTrue((boolean)this.sip.hasMethod(Sip.Method.INFO));
    }

    @Test
    public void testSipOPTIONS() {
        byte[] byArray = FormatUtils.toByteArray("000000010006000c2903748300000800450002ba834000004011118d0a1e678c0a1e679e13e213c402a643e64f5054494f4e53207369703a31302e33302e3130332e3135383a353036303b7472616e73706f72743d756470205349502f322e300d0a5669613a205349502f322e302f5544502031302e33302e3130332e3134303a353039303b72706f72743b6272616e63683d7a39684734624b6a5336333944334e5a365353480d0a4d61782d466f7277617264733a2037300d0a46726f6d3a203c7369703a6e6f6e654031302e33302e3130332e3135383a353036303b7472616e73706f72743d7564703e3b7461673d4b39585a58793330586742554e0d0a546f3a203c7369703a6e6f6e654031302e33302e3130332e3135383a353036303b7472616e73706f72743d7564703e0d0a43616c6c2d49443a2036346237343239302d333635642d313233302d363139312d3030306332393033373436660d0a435365713a203234303335313530204f5054494f4e530d0a436f6e746163743a203c7369703a67772b666c69704031302e33302e3130332e3134303a353039303b7472616e73706f72743d7564703b67773d666c69703e0d0a557365722d4167656e743a20467265655357495443482d6d6f645f736f6669612f312e302e686561642d6769742d6662366539373920323031312d30382d32362030342d34382d3333202b303030300d0a416c6c6f773a20494e564954452c2041434b2c204259452c2043414e43454c2c204f5054494f4e532c204d4553534147452c205550444154452c20494e464f2c2052454749535445522c2052454645522c204e4f544946590d0a537570706f727465643a2074696d65722c20707265636f6e646974696f6e2c20706174682c207265706c616365730d0a416c6c6f772d4576656e74733a2074616c6b2c20686f6c642c2072656665720d0a436f6e74656e742d4c656e6774683a20300d0a0d0a");
        JMemoryPacket jMemoryPacket = new JMemoryPacket(SLL.ID, byArray);
        out.println(jMemoryPacket.getState().toDebugString());
        out.println(jMemoryPacket);
        TestCase.assertTrue((boolean)jMemoryPacket.hasHeader(this.sip));
        TestCase.assertEquals((Object)((Object)AbstractMessageHeader.MessageType.REQUEST), (Object)((Object)this.sip.getMessageType()));
        TestCase.assertTrue((boolean)this.sip.hasField(Sip.Request.RequestMethod));
        TestCase.assertEquals((String)"OPTIONS", (String)this.sip.fieldValue(Sip.Request.RequestMethod));
        TestCase.assertEquals((Object)((Object)Sip.Method.OPTIONS), (Object)((Object)this.sip.getMethod()));
        TestCase.assertTrue((boolean)this.sip.hasMethod(Sip.Method.OPTIONS));
    }

    public void testSipINVITE() {
        byte[] byArray = FormatUtils.toByteArray("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");
        JMemoryPacket jMemoryPacket = new JMemoryPacket(SLL.ID, byArray);
        out.println(jMemoryPacket.getState().toDebugString());
        out.println(jMemoryPacket);
        TestCase.assertTrue((boolean)jMemoryPacket.hasHeader(this.sip));
        TestCase.assertEquals((Object)((Object)AbstractMessageHeader.MessageType.REQUEST), (Object)((Object)this.sip.getMessageType()));
        TestCase.assertTrue((boolean)this.sip.hasField(Sip.Request.RequestMethod));
        TestCase.assertEquals((String)"INVITE", (String)this.sip.fieldValue(Sip.Request.RequestMethod));
        TestCase.assertEquals((Object)((Object)Sip.Method.INVITE), (Object)((Object)this.sip.getMethod()));
        TestCase.assertTrue((boolean)this.sip.hasMethod(Sip.Method.INVITE));
    }

    @Test
    public void testSipACK() {
        byte[] byArray = FormatUtils.toByteArray("000000010006000c2903748300000800450001cc83420000401112790a1e678c0a1e679e13e213c401b845f341434b207369703a31323334353637384031302e33302e3130332e3135383a353036303b7472616e73706f72743d554450205349502f322e300d0a5669613a205349502f322e302f5544502031302e33302e3130332e3134303a353039303b72706f72743b6272616e63683d7a39684734624b6d42534e4434347653723679720d0a4d61782d466f7277617264733a2037300d0a46726f6d3a20226565732066666667676722203c7369703a363132304031302e33302e3130332e3134303e3b7461673d6d6a51725a536d3474533144480d0a546f3a203c7369703a31323334353637384031302e33302e3130332e3135383a353036303e3b7461673d313231333538333131333430323934353734303030312e300d0a43616c6c2d49443a2036366132363137392d333635642d313233302d363139312d3030306332393033373436660d0a435365713a2032393831313232322041434b0d0a436f6e746163743a203c7369703a67772b666c69704031302e33302e3130332e3134303a353039303b7472616e73706f72743d7564703b67773d666c69703e0d0a436f6e74656e742d4c656e6774683a20300d0a0d0a");
        JMemoryPacket jMemoryPacket = new JMemoryPacket(SLL.ID, byArray);
        out.println(jMemoryPacket.getState().toDebugString());
        out.println(jMemoryPacket);
        TestCase.assertTrue((boolean)jMemoryPacket.hasHeader(this.sip));
        TestCase.assertEquals((Object)((Object)AbstractMessageHeader.MessageType.REQUEST), (Object)((Object)this.sip.getMessageType()));
        TestCase.assertTrue((boolean)this.sip.hasField(Sip.Request.RequestMethod));
        TestCase.assertEquals((String)"ACK", (String)this.sip.fieldValue(Sip.Request.RequestMethod));
        TestCase.assertEquals((Object)((Object)Sip.Method.ACK), (Object)((Object)this.sip.getMethod()));
        TestCase.assertTrue((boolean)this.sip.hasMethod(Sip.Method.ACK));
    }

    public void testSipBYE() {
        byte[] byArray = FormatUtils.toByteArray("000000010006000c2903748300000800450002d6834300004011116e0a1e678c0a1e679e13e213c402c23817425945207369703a31323334353637384031302e33302e3130332e3135383a353036303b7472616e73706f72743d554450205349502f322e300d0a5669613a205349502f322e302f5544502031302e33302e3130332e3134303a353039303b72706f72743b6272616e63683d7a39684734624b70584237677436334b614b34460d0a4d61782d466f7277617264733a2037300d0a46726f6d3a20226565656565756767676722203c7369703a363132304031302e33302e3130332e3134303e3b7461673d6d6a51725a536d3474533144480d0a546f3a203c7369703a31323334353637384031302e33302e3130332e3135383a353036303e3b7461673d313231333538333131333430323934353734303030312e300d0a43616c6c2d49443a2036366132363137392d333635642d313233302d363139312d3030306332393033373436660d0a435365713a203239383131323233204259450d0a436f6e746163743a203c7369703a67772b666c69704031302e33302e3130332e3134303a353039303b7472616e73706f72743d7564703b67773d666c69703e0d0a557365722d4167656e743a20467265655357495443482d6d6f645f736f6669612f312e302e686561642d6769742d6662366539373920323031312d30382d32362030342d34382d3333202b303030300d0a416c6c6f773a20494e564954452c2041434b2c204259452c2043414e43454c2c204f5054494f4e532c204d4553534147452c205550444154452c20494e464f2c2052454749535445522c2052454645522c204e4f544946590d0a537570706f727465643a2074696d65722c20707265636f6e646974696f6e2c20706174682c207265706c616365730d0a526561736f6e3a20512e3835303b63617573653d31363b746578743d224e4f524d414c5f434c454152494e47220d0a436f6e74656e742d4c656e6774683a20300d0a0d0a");
        JMemoryPacket jMemoryPacket = new JMemoryPacket(SLL.ID, byArray);
        out.println(jMemoryPacket.getState().toDebugString());
        out.println(jMemoryPacket);
        TestCase.assertTrue((boolean)jMemoryPacket.hasHeader(this.sip));
        TestCase.assertEquals((Object)((Object)AbstractMessageHeader.MessageType.REQUEST), (Object)((Object)this.sip.getMessageType()));
        TestCase.assertTrue((boolean)this.sip.hasField(Sip.Request.RequestMethod));
        TestCase.assertEquals((String)"BYE", (String)this.sip.fieldValue(Sip.Request.RequestMethod));
        TestCase.assertEquals((Object)((Object)Sip.Method.BYE), (Object)((Object)this.sip.getMethod()));
        TestCase.assertTrue((boolean)this.sip.hasMethod(Sip.Method.BYE));
    }

    @Test
    public void testReadAllPackets() {
        String[] stringArray = new String[]{"tests/test-sip-rtp.pcap", "tests/test-sip-rtp-g711.pcap", "tests/test-sip-info-packets.pcap"};
        boolean bl = true;
        Sip sip = new Sip();
        for (String string : stringArray) {
            if (!new File(string).exists()) continue;
            out.println("================= " + string + " =================");
            for (PcapPacket pcapPacket : TestUtils.getIterable(string)) {
                if (!pcapPacket.hasHeader(sip)) continue;
                System.out.println(pcapPacket.getState().toDebugString());
                if (sip.getMethod() != null) continue;
                out.println(sip);
            }
        }
    }
}

